= net/http.rb

== Υ饤֥ˤĤ

ѥǡžץȥ HTTP 򰷤饤֥Ǥ
 [RFC2616] ((<URL:http://www.ietf.org/rfc/rfc2616.txt>))
˴𤭤ޤ

*((<Net::HTTP>))
*((<Net::HTTPRequest>))
*((<Net::HTTPResponse>))

ΥڡΤ⤯

*((<"net/http.rb"/>))
*((<"net/http.rb"/ͤؤѹȰܹ֤ˤĤ>))
*((<"net/http.rb"/㳰>))
*((<"net/http.rb"/եͤζڤʸˤĤ>))

== 

=== ֥ФɥȤ (GET)

    require 'net/http'
    Net::HTTP.version_1_2   # ޤʤ
    Net::HTTP.start('www.example.com', 80) {|http|
      response = http.get('/index.html')
      puts response.body
    }

ޤʲƱ̣û񤤤ΤǤ

    require 'net/http'
    Net::HTTP.version_1_2   # ޤʤ
    Net::HTTP.get_print 'www.example.com', '/index.html'

=== եξ (POST)

    require 'net/http'
    Net::HTTP.version_1_2   # ޤʤ
    Net::HTTP.start('www.example.com', 80) {|http|
      response = http.post('/cgi-bin/somecgi.rb',
                           'querytype=subject&target=ruby')
    }

(: ((<"net/http.rb"/եͤζڤʸˤĤ>)))

=== ץͳΥ

Net::HTTP Υ饹᥽å Net::HTTP.Proxy ϡ˥ץͳ
³褦ư򤹤롢饹֤ޤΥ饹
Net::HTTP ѾƤΤ Net::HTTP Ʊ褦˻Ȥޤ

    require 'net/http'
    Net::HTTP.version_1_2   # ޤʤ

    $proxy_addr = 'your.proxy.addr'
    $proxy_port = 8080
          :
    Net::HTTP::Proxy($proxy_addr, $proxy_port).start( 'some.www.server' ) {|http|
      # always connect to your.proxy.addr:8080
          :
    }

ޤ Net::HTTP.Proxy  nil  Net::HTTP Ȥ֤Τ
ΥɤΤ褦˽񤤤ƤХץʤξˤбǤޤ

=== 쥯Ȥб

ʲΥ᥽å fetch ϥ쥯ȤбƤޤ
limit ʾ쥯Ȥ饨顼ˤޤ

    require 'uri'
    require 'net/http'
    Net::HTTP.version_1_2    # ޤʤ

    def fetch( uri_str, limit = 10 )
      # Ŭڤ㳰饹Ѥ٤
      raise ArgumentError, 'http redirect too deep' if limit == 0
  
      response = Net::HTTP.get_response(URI.parse(uri_str))
      case response
      when Net::HTTPSuccess     then response
      when Net::HTTPRedirection then fetch(response['location'], limit - 1)
      else
        response.error!
      end
    end

    print fetch('http://www.ruby-lang.org')

Ruby 1.6.7 ̤ˤ URI 饹ɸźդƤʤΤǡĴã뤫
뤤ϤʤʲΤ褦ˤƤ

    require 'net/http'
    Net::HTTP.version_1_2   # ޤʤ

    def fetch( uri_str, limit = 10 )
      # Ŭڤ㳰饹Ѥ٤
      raise ArgumentError, 'http redirect too deep' if limit == 0
  
      response = Net::HTTP.get_response(*split_uri(uri_str))
      case response
      when Net::HTTPSuccess     then response
      when Net::HTTPRedirection then fetch(response['location'], limit - 1)
      else
        response.error!
      end
    end

    def split_uri( uri_str )
      m = %r<http://([^/]+)>.match(uri_str) or raise ArgumentError, "cannot parse URI: #{uri_str}"
      host = m[1].strip
      path = m.post_match
      path = '/' if path.empty?
      return host, path
    end

    print fetch('http://www.ruby-lang.org')

=== Basic ǧ

    require 'net/http'
    Net::HTTP.version_1_2   # ޤʤ

    req = Net::HTTP::Get.new('/need-auth.cgi')
    req.basic_auth 'account', 'password'
    Net::HTTP.start('www.example.com') {|http|
      response = http.request(req)
      print response.body
    }

== ͤؤѹȰܹ֤ˤĤ

Ruby 1.6 äƤΤ http.rb 1.1  1.7 ʹߤ 1.2 Ǥ
δ֤ǤϤʤ礭ͤѤޤ˻ͤѹ
ΤǤʤξμ¸ߤ뤳Ȥˤޤ

᥽å HTTP.version_1_2HTTP.version_1_1 Ƥ֤
ΤȤ Net::HTTP ֥ȤϤ줾
Сλͤư褦ˤʤޤʲϻǤ

    # example
    Net::HTTP.start {|http1| ...(http1 has 1.2 features)... }

    Net::HTTP.version_1_1
    Net::HTTP.start {|http2| ...(http2 has 1.1 features)... }

    Net::HTTP.version_1_2
    Net::HTTP.start {|http3| ...(http3 has 1.2 features)... }

Ĥޤ Ruby 1.6 Ǥ Net::HTTP.version_1_2 Ƥ٤ 1.2 εưˤʤޤ
ȾΥ᥽åɤϸƤ٤ޤ (Ruby 1.8 Ǥ᥽åɤƤΤƤǤϤޤ)
Ruby 1.8 Ǥ Net::HTTP.version_1_1 Ƥ٤иεưˤǤΤǡߴ
ݤĤȤǤޤ

εǽϥåɥդǤϤޤ
ĤޤꡢʣåɤǤ줾 version_1_1  version_1_2 Ƥ硢
 Net::HTTP ֥ȤɤΥСˤʤ뤫ݾڤǤޤ
ץꥱΤǤɤ餫ΥС˸ꤹɬפޤ

ʤɤȤǤ줫񤯤ʤ version_1_2 Ǥ
require 'net/http' ľ Net::HTTP.version_1_2 Ƥ
1.1 ΤȤ˺Ƥ

== 㳰

getheadpost ᥽åɤȯ HTTP ץȥϢ㳰Ȥơ
ʲ˵󤲤Τޤ
˵󤲤㳰饹οƥ饹Ϥ٤ Net::ProtocolError 饹ǡ
response ᥽åɤˤäƥ顼θȤʤä쥹ݥ󥹥֥Ȥ
뤳ȤǤޤ

  * ProtoRetriableError

    HTTP ơ 3xx äȯޤ
    ꥽ưʤɤͳˤꡢꥯȤλˤϹ
    륢ɬפˤʤޤ

  * ProtoFatalError

    HTTP ơ 4xx äȯޤ
    饤ȤΥꥯȤ˸꤬뤫Ф˥ꥯȤݤ
    줿(ǧڤɬס꥽¸ߤʤʤɤ)Ȥ򼨤ޤ

  * ProtoServerError

    HTTP ơ 5xx äȯޤ
    ФꥯȤ˥顼ȯȤ򼨤ޤ

  * ProtoUnknownError

    ץȥΥС󤬾夬ä뤤ϥ饤֥ΥХʤɤǡ
    饤֥꤬бƤʤȯޤ

== եͤζڤʸˤĤ

POST application/x-www-form-urlencoded ȤʣΥեͤ硢
߹ԤʤƤΤϡ name0=value0&name1=value1 Τ褦˥ѥ 
`&' Ƕڤ꤫Ǥ
ˡϡRFC1866 Hypertext Markup Language - 2.0 ǽƸо줷
HTML 4.01 Specification  
((<17.13.4 Form content types|URL:http://www.w3.org/TR/html401/interact/forms.html#h-17.13.4.1>)) 
Ǥ⤽Τ褦˽񤫤Ƥޤ

ȤƱ HTML 4.01 Specification 
((<B.2.2 Ampersands in URI attribute values|URL:http://www.w3.org/TR/html401/appendix/notes.html#h-B.2.2>))
Ǥϡ `&' SGMLʸλȤѤ뤳ȤŦƤꡢ
CGI䥵ФμԤФ `&' 
ߥ `;' 򥵥ݡȤ뤳Ȥ򾩤Ƥޤ

ºݤˤ `;' ᤷʤCGI䥵Фޤޤ뤿
Υե󥹥ޥ˥奢ǤȤ `&' Ѥޤ

ʤ Ruby ɸ ((<cgi.rb>)) Ǥ &  ; ξݡȤƤޤΤǡ
((<cgi.rb>)) Ȥä CGI ץȤ񤯾Ϥΰ㤤򵤤ˤ
ɬפϤޤ
