#
# this file was generated by
#     ruby -e 'print ARGF.read.scan(/^=begin.*?$(.*?)^=end.*?$/m).
#                join.gsub(/\(\(</, "((<optparse.rb/").
#                gsub(/<<</, "see the")' optparse.rb
#
= optparse.rb

((<optparse::塼ȥꥢ>))

= Summary
Library for command line option analysis.

features:
(1) It is possible <option switch of a short form and a long form> to
    exist together. It is also possible in one to bring the switch of
    a short form together.
(2) It is possible to write bringing specification and the handler of
    the switch together respectively in one place.
(3) The argument of the switch is converted into the class which
    automatically specifies it.
(4) The option summary can be made.
(5) The option can be added on the way later.



== Class tree
   * ((<optparse.rb/OptionParser>)) front end
   * ((<optparse.rb/OptionParser::Switch>)) each switches
   * ((<optparse.rb/OptionParser::List>)) options list
   * ((<optparse.rb/OptionParser::ParseError>)) errors on parsing
     * ((<optparse.rb/OptionParser::AmbiguousOption>))
     * ((<optparse.rb/OptionParser::NeedlessArgument>))
     * ((<optparse.rb/OptionParser::MissingArgument>))
     * ((<optparse.rb/OptionParser::InvalidOption>))
     * ((<optparse.rb/OptionParser::InvalidArgument>))
       * ((<optparse.rb/OptionParser::AmbiguousArgument>))

== Object relations
   +--------------+
   | OptionParser |<>-----+
   +--------------+       |                      +--------+
                          |                    ,-| Switch |
        on_head -------->+---------------+    /  +--------+
        accept/reject -->| List          |<|>-
                         |               |<|>-  +----------+
        on ------------->+---------------+    `-| argument |
                         :               :      |  class   |
                         +---------------+      |==========|
        on_tail -------->|               |      |pattern   |
                         +---------------+      |----------|
   OptionParser.accept ->| DefaultList   |      |converter |
                reject   |(shared between|      +----------+
                         | all instances)|
                         +---------------+


= Classes & Modules

== ((:OptionParser::Completion:))
Keyword completion module.

--- OptionParser::Completion#complete(key[, pat])
    Searches ((|key|)), or ((|pat|)) with completion if not found.
    :Parameters:
      : ((|key|))
        keyword to search.
      : ((|pat|))
        completion pattern.

--- OptionParser::Completion#convert(opt, *val)
    Extracts the first element from result of
    ((<optparse.rb/OptionParser::Completion#complete>)).

== ((:OptionParser::OptionMap:))
Map from option/keyword string to object with completion.
=== Superclass
(({Hash}))
=== Including modules
((<optparse.rb/OptionParser::Completion>))

== ((:OptionParser::Switch:))
Individual switch class.

=== Class methods

--- OptionParser::Switch.guess(arg)
    Guesses argument style from ((|arg|)).
    Returns corresponding ((<optparse.rb/OptionParser::Switch>)) subclass.

--- OptionParser::Switch.new

=== Instance methods

--- OptionParser::Switch#parse_arg(arg) {non-serious error handler}
    Parses argument and returns rest of ((|arg|)), and matched portion
    to the argument pattern.
    :Parameters:
      : ((|arg|))
        option argument to be parsed.
      : (({block}))
        yields when the pattern doesn't match sub-string.

--- OptionParser::Switch#conv_arg(arg, val) {semi-error handler}
    Parses argument, convert and returns ((|arg|)), ((|block|)) and
    result of conversion.
    : Arguments to ((|@conv|))
      substrings matched to ((|@pattern|)), ((|$&|)), ((|$1|)),
      ((|$2|)) and so on.
    :Parameters:
      : ((|arg|))
        argument string follows the switch.
      : ((|val|))
        following argument.
      : (({block}))
        (({yields})) at semi-error condition, instead of raises exception.

--- OptionParser::Switch#summarize(sdone, ldone, width, max, indent)
    Makes summary strings.
    :Parameters:
      : ((|sdone|))
        already summarized short style options keyed hash.
      : ((|ldone|))
        already summarized long style options keyed hash.
      : ((|width|))
        width of left side, option part. in other word, right side,
        description part strings start at ((|width|)) column.
      : ((|max|))
        maximum width of left side, options are filled within ((|max|)) columns.
      : ((|indent|))
        prefix string indents each summarized lines.
      : (({block}))
        to be passed each lines(without newline).

== Switch classes

=== ((:OptionParser::Switch::NoArgument:))
Switch that takes no arguments.
==== Superclass
((<optparse.rb/OptionParser::Switch>))
==== Instance methods
--- OptionParser::Switch::NoArgument#parse
    Raises an exception if any arguments given.

=== ((:OptionParser::Switch::RequiredArgument:))
Switch that takes an argument.
==== Superclass
((<optparse.rb/OptionParser::Switch>))
==== Instance methods
--- OptionParser::Switch::RequiredArgument#parse
    Raises an exception if argument is not present.

=== ((:OptionParser::Switch::OptionalArgument:))
Switch that can omit argument.
==== Superclass
((<optparse.rb/OptionParser::Switch>))
==== Instance methods
--- OptionParser::Switch::OptionalArgument#parse
    Parses argument if given, or uses default value.

== ((:OptionParser::List:))
Simple option list providing mapping from short and/or long option
string to ((<optparse.rb/OptionParser::Switch>)), and mapping from acceptable
argument to matching pattern and converter pair.  Also provides
summary feature.

=== Class methods

--- OptionParser::List.new
    Just initializes all instance variables.

=== Instance methods

--- OptionParser::List#atype
    Map from acceptable argument types to pattern and converter pairs.
--- OptionParser::List#short
    Map from short style option switches to actual switch objects.
--- OptionParser::List#long
    Map from long style option switches to actual switch objects.
--- OptionParser::List#list
    List of all switches and summary string.

--- OptionParser::List#accept(type[, pattern]) {...}
    see ((<optparse.rb/OptionParser.accept>)).
--- OptionParser::List#reject(type)
    see ((<optparse.rb/OptionParser.reject>)).

--- OptionParser::List#update(sw, sopts, lopts, nlopts = nil)
    Adds ((|sw|)) according to ((|sopts|)), ((|lopts|)) and
    ((|nlopts|)).
    :Parameters:
      : ((|sw|))
        ((<optparse.rb/OptionParser::Switch>)) instance to be added.
      : ((|sopts|))
        short style options list.
      : ((|lopts|))
        long style options list.
      : ((|nlopts|))
        negated long style options list.

--- OptionParser::List#prepend(switch, short_opts, long_opts, nolong_opts)
    Inserts ((|switch|)) at head of the list, and associates short,
    long and negated long options.
--- OptionParser::List#append(switch, short_opts, long_opts, nolong_opts)
    Appends ((|switch|)) at tail of the list, and associates short,
    long and negated long options.
    :Parameters:
      : ((|switch|))
        ((<optparse.rb/OptionParser::Switch>)) instance to be inserted.
      : ((|short_opts|))
        list of short style options.
      : ((|long_opts|))
        list of long style options.
      : ((|nolong_opts|))
        list of long style options with (({"no-"})) prefix.

--- OptionParser::List#search(id, key) [{block}]
    Searches ((|key|)) in ((|id|)) list.
    :Parameters:
      : ((|id|))
        searching list.
      : ((|k|))
        searching key.
      : (({block}))
        yielded with the found value when succeeded.

--- OptionParser::List#complete(id, opt, *pat, &block)
    Searches list ((|id|)) for ((|opt|)) and ((|*pat|)).
    :Parameters:
      : ((|id|))
        searching list.
      : ((|opt|))
        searching key.
      : ((|*pat|))
        optional pattern for completion.
      : (({block}))
        yielded with the found value when succeeded.

--- OptionParser::List#summarize(*args) {...}
    Making summary table, yields the (({block})) with each lines.
    Each elements of (({@list})) should be able to (({summarize})).
    :Parameters:
      : ((|args|))
        passed to elements#summarize through.
      : (({block}))
        to be passed each lines(without newline).

== ((:OptionParser::CompletingHash:))
(({Hash})) with completion search feature.
=== Superclass
(({Hash}))
=== Including modules
((<optparse.rb/OptionParser::Completion>))

=== Instance methods
--- OptionParser::CompletingHash#match(key)
    Completion for hash key.

== ((:OptionParser:))
The front-end of (({OptionParser})).

=== Constants

--- OptionParser::ArgumentStyle
    Enumeration of acceptable argument styles; possible values are:
    : OptionParser::NO_ARGUMENT
      the switch takes no arguments. ((({:NONE}))) 
    : OptionParser::REQUIRED_ARGUMENT
      the switch requires an argument. ((({:REQUIRED})))
    : OptionParser::OPTIONAL_ARGUMENT
      the switch requires an optional argument, that is, may take or
      not. ((({:OPTIONAL})))

    Use like (({--switch=argument}))(long style) or
    (({-Xargument}))(short style). For short style, only portion
    matched to ((<optparse.rb/argument pattern>)) is dealed as argument.

--- OptionParser::DefaultList
    Switches common used such as '--', and also provides default
    argument classes

=== Default options
Default options, which never appear in option summary.
--- --help
    Shows option summary.
--- --version
    Shows version string if (({::Version})) is defined.

=== Class methods

--- OptionParser.with([banner[, width[, indent]]]) [{...}]
    Initializes new instance, and evaluates the block in context of
    the instance if called as iterator.  This behavior is equivalent
    to older (({new})).  This is ((*deprecated*)) method.
    
    cf. ((<optparse.rb/OptionParser.new>))
    :Parameters:
      : ((|banner|))
        banner message.
      : ((|width|))
        summary width.
      : ((|indent|))
        summary indent.
      : (({block}))
        to be evaluated in the new instance context.

--- OptionParser.inc(arg[, default])
--- OptionParser#inc(arg[, default])
    Returns incremented value of ((|default|)) according to ((|arg|)).

--- OptionParser.new([banner[, width[, indent]]]) [{...}]
    Initializes the instance, and yields itself if called as iterator.
    :Parameters:
      : ((|banner|))
        banner message.
      : ((|width|))
        summary width.
      : ((|indent|))
        summary indent.
      : (({block}))
        to be evaluated in the new instance context.

--- OptionParser.terminate([arg])
    Terminates option parsing. Optional parameter ((|arg|)) would be
    pushed back if given.
    :Parameters:
      : ((|arg|))
        string pushed back to be first non-option argument

--- OptionParser.accept(t, [pat]) {...}
--- OptionParser#accept(t, [pat]) {...}
    Directs to accept specified class argument.
    :Parameters:
      : ((|t|))
        argument class specifier, any object including Class.
      : ((|pat|))
        pattern for argument, defaulted to ((|t|)) if it respond to (({match})).
      : (({block}))
        receives argument string and should be convert to desired class.

--- OptionParser.reject(t)
--- OptionParser#reject(t)
    Directs to reject specified class argument.
    :Parameters:
      : ((|t|))
        argument class specifier, any object including Class.

=== Instance methods

--- OptionParser#banner
--- OptionParser#banner=(heading)
    Heading banner preceding summary.
--- OptionParser#summary_width
--- OptionParser#summary_width=(width)
    Width for option list portion of summary. Must be (({Numeric})).
--- OptionParser#summary_indent
--- OptionParser#summary_indent=(indent)
    Indentation for summary. Must be (({String})) (or have (({+ String}))).
--- OptionParser#program_name
--- OptionParser#program_name=(name)
    Program name to be emitted in error message and default banner,
    defaulted to (({$0})).

--- OptionParser#version
--- OptionParser#version=(ver)
    Version.
--- OptionParser#release
--- OptionParser#release=(rel)
    Release code.
--- OptionParser#ver
    Returns version string from ((<optparse.rb/program_name>)), (({version})) and
    (({release})).

--- OptionParser#top
    Subject of ((<optparse.rb/on>))/((<optparse.rb/on_head>)), ((<optparse.rb/accept>))/((<optparse.rb/reject>)).

--- OptionParser#base
    Subject of ((<optparse.rb/on_tail>)).

--- OptionParser#new
    Pushes a new (({List})).

--- OptionParser#remove
    Removes the last (({List})).

--- OptionParser#summarize(to = [], width = @summary_width, max = width - 1, indent = @summary_indent)
    Puts option summary into ((|to|)), and returns ((|to|)).
    :Parameters:
      : ((|to|))
        output destination, which must have method ((|<<|)). Defaulted to (({[]})).
      : ((|width|))
        width of left side. Defaulted to ((|@summary_width|))
      : ((|max|))
        maximum length allowed for left side. Defaulted to (({((|width|)) - 1}))
      : ((|indent|))
        indentation. Defaulted to ((|@summary_indent|))
      : (({block}))
        yields with each line if called as iterator.

--- OptionParser#help
--- OptionParser#to_s
    Returns option summary string.

--- OptionParser#to_a
    Returns option summary list.

--- OptionParser#switch
    Creates ((<optparse.rb/OptionParser::Switch>)).
    :Parameters:
      : ((|*opts|))
        option definition:
        : argument style
          see ((<optparse.rb/OptionParser::ArgumentStyle>))
        : argument pattern
          acceptable option argument format, must pre-defined with
          ((<optparse.rb/OptionParser.accept>)) or ((<optparse.rb/OptionParser#accept>)), or
          (({Regexp})). This can appear once or assigned as (({String}))
          if not present, otherwise causes exception (({ArgumentError})).
          
          cf. ((<optparse.rb/Acceptable argument classes>)).
        : Hash
        : Array
          possible argument values.
        : Proc
        : Method
          alternative way to give the ((*handler*)).
        : "--switch=MANDATORY", "--switch[=OPTIONAL]", "--switch"
          specifies long style switch that takes ((*mandatory*)),
          ((*optional*)) and ((*no*)) argument, respectively.
        : "-xMANDATORY", "-x[OPTIONAL]", "-x"
          specifies short style switch that takes ((*mandatory*)),
          ((*optional*)) and ((*no*)) argument, respectively.
        : "-[a-z]MANDATORY", "-[a-z][OPTIONAL]", "-[a-z]"
          special form short style switch that matches character
          range(not fullset of regular expression).
        : "=MANDATORY", "=[OPTIONAL]"
          argument style and description.
        : "description", ...
          ((*description*)) for this option.
      : (({block}))
        ((*handler*)) to convert option argument to arbitrary (({Class})).

--- OptionParser#notwice(obj, prv, msg)
    Checks never given twice an argument.
    ((*Called from OptionParser#switch only*))
    :Parameters:
      : ((|obj|))
        new argument.
      : ((|prv|))
        previously specified argument.
      : ((|msg|))
        exception message

--- OptionParser#on(*opts) [{...}]
--- OptionParser#def_option(*opts) [{...}]
--- OptionParser#on_head(*opts) [{...}]
--- OptionParser#def_head_option(*opts) [{...}]
--- OptionParser#on_tail(*opts) [{...}]
--- OptionParser#def_tail_option(*opts) [{...}]
    Defines option switch and handler. (({on_head})), (({def_head_option}))
    and (({on_tail})), (({def_tail_option})) put the switch at head
    and tail of summary, respectively.

    cf. ((<optparse.rb/OptionParser#switch>)).

--- OptionParser#order(*argv) [{...}]
--- OptionParser#order!([argv = ARGV]) [{...}]
    Parses ((|argv|)) in order. When non-option argument encountered,
    yields it if called as iterator, otherwise terminates the parse
    process.
    Returns rest of ((|argv|)) left unparsed.
    
    (({order!})) takes argument array itself, and removes switches
    destructively.
    Defaults to parse ((|ARGV|)).
    :Parameters:
      : ((|argv|))
        command line arguments to be parsed.
      : (({block}))
        called with each non-option argument.

--- OptionParser#permute(*argv)
--- OptionParser#permute!([argv = ARGV])
    Parses ((|argv|)) in permutation mode, and returns list of
    non-option arguments.
    
    (({permute!})) takes argument array itself, and removes switches
    destructively.
    Defaults to parse ((|ARGV|)).
    :Parameters:
      : ((|argv|))
        command line arguments to be parsed.

--- OptionParser#parse(*argv)
--- OptionParser#parse!([argv = ARGV])
    Parses ((|argv|)) in order when environment variable (({POSIXLY_CORRECT}))
    is set, otherwise permutation mode
    
    (({parse!})) takes argument array itself, and removes switches
    destructively.
    Defaults to parse ((|ARGV|)).
    :Parameters:
      : ((|argv|))
        command line arguments to be parsed.

--- OptionParser#visit(id, *args) {block}
    Traverses (({stack}))s calling method ((|id|)) with ((|*args|)).
    :Parameters:
      : ((|id|))
        called method in each elements of (({stack}))s.
      : ((|*args|))
        passed to ((|id|)).
      : (({block}))
        passed to ((|id|)).

--- OptionParser#search(id, k)
    Searches ((|k|)) in stack for ((|id|)) hash, and returns it or yielded
    value if called as iterator.
    :Parameters:
      : ((|id|))
        searching table.
      : ((|k|))
        searching key.
      : (({block}))
        yielded with the found value when succeeded.

--- OptionParser#complete(typ, opt, *etc)
    Completes shortened long style option switch, and returns pair of
    canonical switch and switch descriptor((<optparse.rb/OptionParser::Switch>)).
    :Parameters:
      : ((|id|))
        searching table.
      : ((|opt|))
        searching key.
      : ((|*pat|))
        optional pattern for completion.
      : (({block}))
        yielded with the found value when succeeded.

--- OptionParser#load([filename])
    Loads options from file named as ((|filename|)). Does nothing when
    the file is not present. Returns whether successfuly loaded.
    :Parameters:
      : ((|filename|))
        option file name.  defaulted to basename of the program without
        suffix in a directory ((%~/.options%)).

--- OptionParser#environment([env])
    Parses environment variable ((|env|)) or its uppercase with spliting
    like as shell.
    :Parameters:
      : ((|env|))
        defaulted to basename of the program.

= Acceptable argument classes

: Object
  any string, and no conversion. this is fall-back.

: String
  any none-empty string, and no conversion.

: Integer
  Ruby/C-like integer, octal for (({0-7})) sequence, binary for
  (({0b})), hexadecimal for (({0x})), and decimal for others; with
  optional sign prefix. Converts to (({Integer})).

: Float
  Float number format, and converts to (({Float})).

: Numeric
  Generic numeric format, and converts to (({Integer})) for integer
  format, (({Float})) for float format.

: OptionParser::DecimalInteger
  Decimal integer format, to be converted to (({Integer})).

: OptionParser::OctalInteger
  Ruby/C like octal/hexadecimal/binary integer format, to be converted
  to (({Integer})).

: OptionParser::DecimalNumeric
  Decimal integer/float number format, to be converted to
  (({Integer})) for integer format, (({Float})) for float format.

: TrueClass
  Boolean switch, which means whether it is present or not, whether it
  is absent or not with prefix (({no-})), or it takes an argument
  (({yes/no/true/false/+/-})).
: FalseClass
  Similar to ((<optparse.rb/TrueClass>)), but defaulted to (({false})).

: Array
  List of strings separated by ","

= Exceptions

== ((:OptionParser::ParseError:))
Base class of exceptions from ((<optparse.rb/OptionParser>))
=== Superclass
(({RuntimeError}))
=== Constants
: OptionParser::ParseError::Reason
  Reason caused error.
=== Instance methods
--- OptionParser::ParseError#recover(argv)
    Push backs erred argument(s) to ((|argv|)).
--- OptionParser::ParseError#reason
    Returns error reason. Override this to I18N.
--- OptionParser::ParseError#inspect
    Returns inspection string.
--- OptionParser::ParseError#message
--- OptionParser::ParseError#to_s
--- OptionParser::ParseError#to_str
    Default stringizing method to emit standard error message.

== ((:OptionParser::AmbiguousOption:))
Raises when encountered ambiguously completable string.
=== Superclass
((<optparse.rb/OptionParser::ParseError>))

== ((:OptionParser::NeedlessArgument:))
Raises when encountered argument for switch defined as which takes no
argument.
=== Superclass
((<optparse.rb/OptionParser::ParseError>))

== ((:OptionParser::MissingArgument:))
Raises when no argument found for switch defined as which needs
argument.
=== Superclass
((<optparse.rb/OptionParser::ParseError>))

== ((:OptionParser::InvalidOption:))
Raises when undefined switch.
=== Superclass
((<optparse.rb/OptionParser::ParseError>))

== ((:OptionParser::InvalidArgument:))
Raises when the given argument does not match required format.
=== Superclass
((<optparse.rb/OptionParser::ParseError>))

== ((:OptionParser::AmbiguousArgument:))
Raises when the given argument word can't completed uniquely.
=== Superclass
((<optparse.rb/OptionParser::InvalidArgument>))

= Miscellaneous

== ((:OptionParser::Arguable:))
Extends command line arguments array to parse itself.

--- OptionParser::Arguable#options=(opt)
    Sets ((<optparse.rb/OptionParser>)) object, when ((|opt|)) is (({false})) or
    (({nil})), methods ((<optparse.rb/OptionParser::Arguable#options>)) and
    ((<optparse.rb/OptionParser::Arguable#options=>)) are undefined.  Thus, there
    is no ways to access the ((<optparse.rb/OptionParser>)) object via the
    receiver object.

--- OptionParser::Arguable#options
    Actual ((<optparse.rb/OptionParser>)) object, automatically created if not
    yet.

    If called as iterator, yields with the ((<optparse.rb/OptionParser>)) object
    and returns the result of the block. In this case, rescues any
    ((<optparse.rb/OptionParser::ParseError>)) exceptions in the block, just emits
    error message to ((<optparse.rb/STDERR>)) and returns (({nil})).

    :Parameters:
      : (({block}))
        Yielded with the ((<optparse.rb/OptionParser>)) instance.


--- OptionParser::Arguable#order!
--- OptionParser::Arguable#permute!
--- OptionParser::Arguable#parse!
    Parses ((|self|)) destructively, and returns ((|self|)) just contains
    rest arguments left without parsed.

Initializes instance variable.

== OptionParser::Acceptables
Acceptable argument classes.  Now contains (({DecimalInteger})),
(({OctalInteger})) and (({DecimalNumeric})).
see ((<optparse.rb/Acceptable argument classes>)).

= Example
The following example is a complete Ruby program.  You can run it and see the
effect of specifying various options.

  require 'optparse'
  require 'optparse/time'
  require 'ostruct'
  require 'pp'
  
  class OptparseExample
  
    CODES = %w[iso-2022-jp shift_jis euc-jp utf8 binary]
    CODE_ALIASES = {"jis" => "iso-2022-jp", "sjis" => "shift_jis"}
  
    #
    # Return a structure describing the options.
    #
    def self.parse(args)
      # The options specified on the command line will be collected in *options*.
      # We set default values here.
      options = OpenStruct.new
      options.library = []
      options.inplace = false
      options.encoding = "utf8"
      options.transfer_type = :auto
      options.verbose = false
      
      opts = OptionParser.new do |opts|
        opts.banner = "Usage: example.rb [options]"
      
        opts.separator ""
        opts.separator "Specific options:"
      
        # Mandatory argument.
        opts.on("-r", "--require LIBRARY",
                "Require the LIBRARY before executing your script") do |lib|
          options.library << lib
        end
      
        # Optional argument; multi-line description.
        opts.on("-i", "--inplace [EXTENSION]",
                "Edit ARGV files in place",
                "  (make backup if EXTENSION supplied)") do |ext|
          options.inplace = true
          options.extension = ext || ''
          options.extension.sub!(/\A\.?(?=.)/, ".")  # Ensure extension begins with dot.
        end
      
        # Cast 'delay' argument to a Float.
        opts.on("--delay N", Float, "Delay N seconds before executing") do |n|
          options.delay = n
        end
      
        # Cast 'time' argument to a Time object.
        opts.on("-t", "--time [TIME]", Time, "Begin execution at given time") do |time|
          options.time = time
        end
      
        # Cast to octal integer.
        opts.on("-F", "--irs [OCTAL]", OptionParser::OctalInteger,
                "Specify record separator (default \\0)") do |rs|
          options.record_separator = rs
        end
      
        # List of arguments.
        opts.on("--list x,y,z", Array, "Example 'list' of arguments") do |list|
          options.list = list
        end
      
        # Keyword completion.  We are specifying a specific set of arguments (CODES
        # and CODE_ALIASES - notice the latter is a Hash), and the user may provide
        # the shortest unambiguous text.
        code_list = (CODE_ALIASES.keys + CODES).join(',')
        opts.on("--code CODE", CODES, CODE_ALIASES, "Select encoding",
                "  (#{code_list})") do |encoding|
          options.encoding = encoding
        end
      
        # Optional argument with keyword completion.
        opts.on("--type [TYPE]", [:text, :binary, :auto], "Select transfer type (text, binary, auto)") do |t|
          options.transfer_type = t
        end
      
        # Boolean switch.
        opts.on("-v", "--[no-]verbose", "Run verbosely") do |v|
          options.verbose = v
        end
      
        opts.separator ""
        opts.separator "Common options:"
      
        # No argument, shows at tail.  This will print an options summary.
        # Try it and see!
        opts.on_tail("-h", "--help", "Show this message") do
          puts opts
          exit
        end
      
        # Another typical switch to print the version.
        opts.on_tail("--version", "Show version") do
          puts OptionParser::Version.join('.')
          exit
        end
      end
      
      opts.parse!(args)
      options
    end  # parse()
  
  end  # class OptparseExample
  
  options = OptparseExample.parse(ARGV)
  pp options

Note: if you get errors or strange results from any of the above code, make
sure you have the latest version installed.  Some changes have been made since
Ruby 1.8.0 was released. 
