# frozen_string_literal: true

=begin
This file is generated by the templates/template.rb script and should not be
modified manually. See templates/lib/prism/dsl.rb.erb
if you are looking to modify the template
=end

module Prism
  # The DSL module provides a set of methods that can be used to create prism
  # nodes in a more concise manner. For example, instead of writing:
  #
  #     source = Prism::Source.for("[1]")
  #
  #     Prism::ArrayNode.new(
  #       [
  #         Prism::IntegerNode.new(
  #           Prism::IntegerBaseFlags::DECIMAL,
  #           1,
  #           Prism::Location.new(source, 1, 1),
  #           source
  #         )
  #       ],
  #       Prism::Location.new(source, 0, 1),
  #       Prism::Location.new(source, 2, 1),
  #       source
  #     )
  #
  # you could instead write:
  #
  #     source = Prism::Source.for("[1]")
  #
  #     ArrayNode(
  #       IntegerNode(Prism::IntegerBaseFlags::DECIMAL, 1, Location(source, 1, 1)), source),
  #       Location(source, 0, 1),
  #       Location(source, 2, 1),
  #       source
  #     )
  #
  # This is mostly helpful in the context of writing tests, but can also be used
  # to generate trees programmatically.
  module DSL
    private

    # Create a new Location object
    def Location(source = nil, start_offset = 0, length = 0)
      Location.new(source, start_offset, length) # steep:ignore
    end

    # Create a new AliasGlobalVariableNode node
    def AliasGlobalVariableNode(new_name, old_name, keyword_loc, source = nil, location = Location())
      AliasGlobalVariableNode.new(source, new_name, old_name, keyword_loc, location)
    end

    # Create a new AliasMethodNode node
    def AliasMethodNode(new_name, old_name, keyword_loc, source = nil, location = Location())
      AliasMethodNode.new(source, new_name, old_name, keyword_loc, location)
    end

    # Create a new AlternationPatternNode node
    def AlternationPatternNode(left, right, operator_loc, source = nil, location = Location())
      AlternationPatternNode.new(source, left, right, operator_loc, location)
    end

    # Create a new AndNode node
    def AndNode(left, right, operator_loc, source = nil, location = Location())
      AndNode.new(source, left, right, operator_loc, location)
    end

    # Create a new ArgumentsNode node
    def ArgumentsNode(flags, arguments, source = nil, location = Location())
      ArgumentsNode.new(source, flags, arguments, location)
    end

    # Create a new ArrayNode node
    def ArrayNode(flags, elements, opening_loc, closing_loc, source = nil, location = Location())
      ArrayNode.new(source, flags, elements, opening_loc, closing_loc, location)
    end

    # Create a new ArrayPatternNode node
    def ArrayPatternNode(constant, requireds, rest, posts, opening_loc, closing_loc, source = nil, location = Location())
      ArrayPatternNode.new(source, constant, requireds, rest, posts, opening_loc, closing_loc, location)
    end

    # Create a new AssocNode node
    def AssocNode(key, value, operator_loc, source = nil, location = Location())
      AssocNode.new(source, key, value, operator_loc, location)
    end

    # Create a new AssocSplatNode node
    def AssocSplatNode(value, operator_loc, source = nil, location = Location())
      AssocSplatNode.new(source, value, operator_loc, location)
    end

    # Create a new BackReferenceReadNode node
    def BackReferenceReadNode(name, source = nil, location = Location())
      BackReferenceReadNode.new(source, name, location)
    end

    # Create a new BeginNode node
    def BeginNode(begin_keyword_loc, statements, rescue_clause, else_clause, ensure_clause, end_keyword_loc, source = nil, location = Location())
      BeginNode.new(source, begin_keyword_loc, statements, rescue_clause, else_clause, ensure_clause, end_keyword_loc, location)
    end

    # Create a new BlockArgumentNode node
    def BlockArgumentNode(expression, operator_loc, source = nil, location = Location())
      BlockArgumentNode.new(source, expression, operator_loc, location)
    end

    # Create a new BlockLocalVariableNode node
    def BlockLocalVariableNode(flags, name, source = nil, location = Location())
      BlockLocalVariableNode.new(source, flags, name, location)
    end

    # Create a new BlockNode node
    def BlockNode(locals, parameters, body, opening_loc, closing_loc, source = nil, location = Location())
      BlockNode.new(source, locals, parameters, body, opening_loc, closing_loc, location)
    end

    # Create a new BlockParameterNode node
    def BlockParameterNode(flags, name, name_loc, operator_loc, source = nil, location = Location())
      BlockParameterNode.new(source, flags, name, name_loc, operator_loc, location)
    end

    # Create a new BlockParametersNode node
    def BlockParametersNode(parameters, locals, opening_loc, closing_loc, source = nil, location = Location())
      BlockParametersNode.new(source, parameters, locals, opening_loc, closing_loc, location)
    end

    # Create a new BreakNode node
    def BreakNode(arguments, keyword_loc, source = nil, location = Location())
      BreakNode.new(source, arguments, keyword_loc, location)
    end

    # Create a new CallAndWriteNode node
    def CallAndWriteNode(flags, receiver, call_operator_loc, message_loc, read_name, write_name, operator_loc, value, source = nil, location = Location())
      CallAndWriteNode.new(source, flags, receiver, call_operator_loc, message_loc, read_name, write_name, operator_loc, value, location)
    end

    # Create a new CallNode node
    def CallNode(flags, receiver, call_operator_loc, name, message_loc, opening_loc, arguments, closing_loc, block, source = nil, location = Location())
      CallNode.new(source, flags, receiver, call_operator_loc, name, message_loc, opening_loc, arguments, closing_loc, block, location)
    end

    # Create a new CallOperatorWriteNode node
    def CallOperatorWriteNode(flags, receiver, call_operator_loc, message_loc, read_name, write_name, binary_operator, binary_operator_loc, value, source = nil, location = Location())
      CallOperatorWriteNode.new(source, flags, receiver, call_operator_loc, message_loc, read_name, write_name, binary_operator, binary_operator_loc, value, location)
    end

    # Create a new CallOrWriteNode node
    def CallOrWriteNode(flags, receiver, call_operator_loc, message_loc, read_name, write_name, operator_loc, value, source = nil, location = Location())
      CallOrWriteNode.new(source, flags, receiver, call_operator_loc, message_loc, read_name, write_name, operator_loc, value, location)
    end

    # Create a new CallTargetNode node
    def CallTargetNode(flags, receiver, call_operator_loc, name, message_loc, source = nil, location = Location())
      CallTargetNode.new(source, flags, receiver, call_operator_loc, name, message_loc, location)
    end

    # Create a new CapturePatternNode node
    def CapturePatternNode(value, target, operator_loc, source = nil, location = Location())
      CapturePatternNode.new(source, value, target, operator_loc, location)
    end

    # Create a new CaseMatchNode node
    def CaseMatchNode(predicate, conditions, consequent, case_keyword_loc, end_keyword_loc, source = nil, location = Location())
      CaseMatchNode.new(source, predicate, conditions, consequent, case_keyword_loc, end_keyword_loc, location)
    end

    # Create a new CaseNode node
    def CaseNode(predicate, conditions, consequent, case_keyword_loc, end_keyword_loc, source = nil, location = Location())
      CaseNode.new(source, predicate, conditions, consequent, case_keyword_loc, end_keyword_loc, location)
    end

    # Create a new ClassNode node
    def ClassNode(locals, class_keyword_loc, constant_path, inheritance_operator_loc, superclass, body, end_keyword_loc, name, source = nil, location = Location())
      ClassNode.new(source, locals, class_keyword_loc, constant_path, inheritance_operator_loc, superclass, body, end_keyword_loc, name, location)
    end

    # Create a new ClassVariableAndWriteNode node
    def ClassVariableAndWriteNode(name, name_loc, operator_loc, value, source = nil, location = Location())
      ClassVariableAndWriteNode.new(source, name, name_loc, operator_loc, value, location)
    end

    # Create a new ClassVariableOperatorWriteNode node
    def ClassVariableOperatorWriteNode(name, name_loc, binary_operator_loc, value, binary_operator, source = nil, location = Location())
      ClassVariableOperatorWriteNode.new(source, name, name_loc, binary_operator_loc, value, binary_operator, location)
    end

    # Create a new ClassVariableOrWriteNode node
    def ClassVariableOrWriteNode(name, name_loc, operator_loc, value, source = nil, location = Location())
      ClassVariableOrWriteNode.new(source, name, name_loc, operator_loc, value, location)
    end

    # Create a new ClassVariableReadNode node
    def ClassVariableReadNode(name, source = nil, location = Location())
      ClassVariableReadNode.new(source, name, location)
    end

    # Create a new ClassVariableTargetNode node
    def ClassVariableTargetNode(name, source = nil, location = Location())
      ClassVariableTargetNode.new(source, name, location)
    end

    # Create a new ClassVariableWriteNode node
    def ClassVariableWriteNode(name, name_loc, value, operator_loc, source = nil, location = Location())
      ClassVariableWriteNode.new(source, name, name_loc, value, operator_loc, location)
    end

    # Create a new ConstantAndWriteNode node
    def ConstantAndWriteNode(name, name_loc, operator_loc, value, source = nil, location = Location())
      ConstantAndWriteNode.new(source, name, name_loc, operator_loc, value, location)
    end

    # Create a new ConstantOperatorWriteNode node
    def ConstantOperatorWriteNode(name, name_loc, binary_operator_loc, value, binary_operator, source = nil, location = Location())
      ConstantOperatorWriteNode.new(source, name, name_loc, binary_operator_loc, value, binary_operator, location)
    end

    # Create a new ConstantOrWriteNode node
    def ConstantOrWriteNode(name, name_loc, operator_loc, value, source = nil, location = Location())
      ConstantOrWriteNode.new(source, name, name_loc, operator_loc, value, location)
    end

    # Create a new ConstantPathAndWriteNode node
    def ConstantPathAndWriteNode(target, operator_loc, value, source = nil, location = Location())
      ConstantPathAndWriteNode.new(source, target, operator_loc, value, location)
    end

    # Create a new ConstantPathNode node
    def ConstantPathNode(parent, name, delimiter_loc, name_loc, source = nil, location = Location())
      ConstantPathNode.new(source, parent, name, delimiter_loc, name_loc, location)
    end

    # Create a new ConstantPathOperatorWriteNode node
    def ConstantPathOperatorWriteNode(target, binary_operator_loc, value, binary_operator, source = nil, location = Location())
      ConstantPathOperatorWriteNode.new(source, target, binary_operator_loc, value, binary_operator, location)
    end

    # Create a new ConstantPathOrWriteNode node
    def ConstantPathOrWriteNode(target, operator_loc, value, source = nil, location = Location())
      ConstantPathOrWriteNode.new(source, target, operator_loc, value, location)
    end

    # Create a new ConstantPathTargetNode node
    def ConstantPathTargetNode(parent, name, delimiter_loc, name_loc, source = nil, location = Location())
      ConstantPathTargetNode.new(source, parent, name, delimiter_loc, name_loc, location)
    end

    # Create a new ConstantPathWriteNode node
    def ConstantPathWriteNode(target, operator_loc, value, source = nil, location = Location())
      ConstantPathWriteNode.new(source, target, operator_loc, value, location)
    end

    # Create a new ConstantReadNode node
    def ConstantReadNode(name, source = nil, location = Location())
      ConstantReadNode.new(source, name, location)
    end

    # Create a new ConstantTargetNode node
    def ConstantTargetNode(name, source = nil, location = Location())
      ConstantTargetNode.new(source, name, location)
    end

    # Create a new ConstantWriteNode node
    def ConstantWriteNode(name, name_loc, value, operator_loc, source = nil, location = Location())
      ConstantWriteNode.new(source, name, name_loc, value, operator_loc, location)
    end

    # Create a new DefNode node
    def DefNode(name, name_loc, receiver, parameters, body, locals, def_keyword_loc, operator_loc, lparen_loc, rparen_loc, equal_loc, end_keyword_loc, source = nil, location = Location())
      DefNode.new(source, name, name_loc, receiver, parameters, body, locals, def_keyword_loc, operator_loc, lparen_loc, rparen_loc, equal_loc, end_keyword_loc, location)
    end

    # Create a new DefinedNode node
    def DefinedNode(lparen_loc, value, rparen_loc, keyword_loc, source = nil, location = Location())
      DefinedNode.new(source, lparen_loc, value, rparen_loc, keyword_loc, location)
    end

    # Create a new ElseNode node
    def ElseNode(else_keyword_loc, statements, end_keyword_loc, source = nil, location = Location())
      ElseNode.new(source, else_keyword_loc, statements, end_keyword_loc, location)
    end

    # Create a new EmbeddedStatementsNode node
    def EmbeddedStatementsNode(opening_loc, statements, closing_loc, source = nil, location = Location())
      EmbeddedStatementsNode.new(source, opening_loc, statements, closing_loc, location)
    end

    # Create a new EmbeddedVariableNode node
    def EmbeddedVariableNode(operator_loc, variable, source = nil, location = Location())
      EmbeddedVariableNode.new(source, operator_loc, variable, location)
    end

    # Create a new EnsureNode node
    def EnsureNode(ensure_keyword_loc, statements, end_keyword_loc, source = nil, location = Location())
      EnsureNode.new(source, ensure_keyword_loc, statements, end_keyword_loc, location)
    end

    # Create a new FalseNode node
    def FalseNode(source = nil, location = Location())
      FalseNode.new(source, location)
    end

    # Create a new FindPatternNode node
    def FindPatternNode(constant, left, requireds, right, opening_loc, closing_loc, source = nil, location = Location())
      FindPatternNode.new(source, constant, left, requireds, right, opening_loc, closing_loc, location)
    end

    # Create a new FlipFlopNode node
    def FlipFlopNode(flags, left, right, operator_loc, source = nil, location = Location())
      FlipFlopNode.new(source, flags, left, right, operator_loc, location)
    end

    # Create a new FloatNode node
    def FloatNode(value, source = nil, location = Location())
      FloatNode.new(source, value, location)
    end

    # Create a new ForNode node
    def ForNode(index, collection, statements, for_keyword_loc, in_keyword_loc, do_keyword_loc, end_keyword_loc, source = nil, location = Location())
      ForNode.new(source, index, collection, statements, for_keyword_loc, in_keyword_loc, do_keyword_loc, end_keyword_loc, location)
    end

    # Create a new ForwardingArgumentsNode node
    def ForwardingArgumentsNode(source = nil, location = Location())
      ForwardingArgumentsNode.new(source, location)
    end

    # Create a new ForwardingParameterNode node
    def ForwardingParameterNode(source = nil, location = Location())
      ForwardingParameterNode.new(source, location)
    end

    # Create a new ForwardingSuperNode node
    def ForwardingSuperNode(block, source = nil, location = Location())
      ForwardingSuperNode.new(source, block, location)
    end

    # Create a new GlobalVariableAndWriteNode node
    def GlobalVariableAndWriteNode(name, name_loc, operator_loc, value, source = nil, location = Location())
      GlobalVariableAndWriteNode.new(source, name, name_loc, operator_loc, value, location)
    end

    # Create a new GlobalVariableOperatorWriteNode node
    def GlobalVariableOperatorWriteNode(name, name_loc, binary_operator_loc, value, binary_operator, source = nil, location = Location())
      GlobalVariableOperatorWriteNode.new(source, name, name_loc, binary_operator_loc, value, binary_operator, location)
    end

    # Create a new GlobalVariableOrWriteNode node
    def GlobalVariableOrWriteNode(name, name_loc, operator_loc, value, source = nil, location = Location())
      GlobalVariableOrWriteNode.new(source, name, name_loc, operator_loc, value, location)
    end

    # Create a new GlobalVariableReadNode node
    def GlobalVariableReadNode(name, source = nil, location = Location())
      GlobalVariableReadNode.new(source, name, location)
    end

    # Create a new GlobalVariableTargetNode node
    def GlobalVariableTargetNode(name, source = nil, location = Location())
      GlobalVariableTargetNode.new(source, name, location)
    end

    # Create a new GlobalVariableWriteNode node
    def GlobalVariableWriteNode(name, name_loc, value, operator_loc, source = nil, location = Location())
      GlobalVariableWriteNode.new(source, name, name_loc, value, operator_loc, location)
    end

    # Create a new HashNode node
    def HashNode(opening_loc, elements, closing_loc, source = nil, location = Location())
      HashNode.new(source, opening_loc, elements, closing_loc, location)
    end

    # Create a new HashPatternNode node
    def HashPatternNode(constant, elements, rest, opening_loc, closing_loc, source = nil, location = Location())
      HashPatternNode.new(source, constant, elements, rest, opening_loc, closing_loc, location)
    end

    # Create a new IfNode node
    def IfNode(if_keyword_loc, predicate, then_keyword_loc, statements, consequent, end_keyword_loc, source = nil, location = Location())
      IfNode.new(source, if_keyword_loc, predicate, then_keyword_loc, statements, consequent, end_keyword_loc, location)
    end

    # Create a new ImaginaryNode node
    def ImaginaryNode(numeric, source = nil, location = Location())
      ImaginaryNode.new(source, numeric, location)
    end

    # Create a new ImplicitNode node
    def ImplicitNode(value, source = nil, location = Location())
      ImplicitNode.new(source, value, location)
    end

    # Create a new ImplicitRestNode node
    def ImplicitRestNode(source = nil, location = Location())
      ImplicitRestNode.new(source, location)
    end

    # Create a new InNode node
    def InNode(pattern, statements, in_loc, then_loc, source = nil, location = Location())
      InNode.new(source, pattern, statements, in_loc, then_loc, location)
    end

    # Create a new IndexAndWriteNode node
    def IndexAndWriteNode(flags, receiver, call_operator_loc, opening_loc, arguments, closing_loc, block, operator_loc, value, source = nil, location = Location())
      IndexAndWriteNode.new(source, flags, receiver, call_operator_loc, opening_loc, arguments, closing_loc, block, operator_loc, value, location)
    end

    # Create a new IndexOperatorWriteNode node
    def IndexOperatorWriteNode(flags, receiver, call_operator_loc, opening_loc, arguments, closing_loc, block, binary_operator, binary_operator_loc, value, source = nil, location = Location())
      IndexOperatorWriteNode.new(source, flags, receiver, call_operator_loc, opening_loc, arguments, closing_loc, block, binary_operator, binary_operator_loc, value, location)
    end

    # Create a new IndexOrWriteNode node
    def IndexOrWriteNode(flags, receiver, call_operator_loc, opening_loc, arguments, closing_loc, block, operator_loc, value, source = nil, location = Location())
      IndexOrWriteNode.new(source, flags, receiver, call_operator_loc, opening_loc, arguments, closing_loc, block, operator_loc, value, location)
    end

    # Create a new IndexTargetNode node
    def IndexTargetNode(flags, receiver, opening_loc, arguments, closing_loc, block, source = nil, location = Location())
      IndexTargetNode.new(source, flags, receiver, opening_loc, arguments, closing_loc, block, location)
    end

    # Create a new InstanceVariableAndWriteNode node
    def InstanceVariableAndWriteNode(name, name_loc, operator_loc, value, source = nil, location = Location())
      InstanceVariableAndWriteNode.new(source, name, name_loc, operator_loc, value, location)
    end

    # Create a new InstanceVariableOperatorWriteNode node
    def InstanceVariableOperatorWriteNode(name, name_loc, binary_operator_loc, value, binary_operator, source = nil, location = Location())
      InstanceVariableOperatorWriteNode.new(source, name, name_loc, binary_operator_loc, value, binary_operator, location)
    end

    # Create a new InstanceVariableOrWriteNode node
    def InstanceVariableOrWriteNode(name, name_loc, operator_loc, value, source = nil, location = Location())
      InstanceVariableOrWriteNode.new(source, name, name_loc, operator_loc, value, location)
    end

    # Create a new InstanceVariableReadNode node
    def InstanceVariableReadNode(name, source = nil, location = Location())
      InstanceVariableReadNode.new(source, name, location)
    end

    # Create a new InstanceVariableTargetNode node
    def InstanceVariableTargetNode(name, source = nil, location = Location())
      InstanceVariableTargetNode.new(source, name, location)
    end

    # Create a new InstanceVariableWriteNode node
    def InstanceVariableWriteNode(name, name_loc, value, operator_loc, source = nil, location = Location())
      InstanceVariableWriteNode.new(source, name, name_loc, value, operator_loc, location)
    end

    # Create a new IntegerNode node
    def IntegerNode(flags, value, source = nil, location = Location())
      IntegerNode.new(source, flags, value, location)
    end

    # Create a new InterpolatedMatchLastLineNode node
    def InterpolatedMatchLastLineNode(flags, opening_loc, parts, closing_loc, source = nil, location = Location())
      InterpolatedMatchLastLineNode.new(source, flags, opening_loc, parts, closing_loc, location)
    end

    # Create a new InterpolatedRegularExpressionNode node
    def InterpolatedRegularExpressionNode(flags, opening_loc, parts, closing_loc, source = nil, location = Location())
      InterpolatedRegularExpressionNode.new(source, flags, opening_loc, parts, closing_loc, location)
    end

    # Create a new InterpolatedStringNode node
    def InterpolatedStringNode(flags, opening_loc, parts, closing_loc, source = nil, location = Location())
      InterpolatedStringNode.new(source, flags, opening_loc, parts, closing_loc, location)
    end

    # Create a new InterpolatedSymbolNode node
    def InterpolatedSymbolNode(opening_loc, parts, closing_loc, source = nil, location = Location())
      InterpolatedSymbolNode.new(source, opening_loc, parts, closing_loc, location)
    end

    # Create a new InterpolatedXStringNode node
    def InterpolatedXStringNode(opening_loc, parts, closing_loc, source = nil, location = Location())
      InterpolatedXStringNode.new(source, opening_loc, parts, closing_loc, location)
    end

    # Create a new ItParametersNode node
    def ItParametersNode(source = nil, location = Location())
      ItParametersNode.new(source, location)
    end

    # Create a new KeywordHashNode node
    def KeywordHashNode(flags, elements, source = nil, location = Location())
      KeywordHashNode.new(source, flags, elements, location)
    end

    # Create a new KeywordRestParameterNode node
    def KeywordRestParameterNode(flags, name, name_loc, operator_loc, source = nil, location = Location())
      KeywordRestParameterNode.new(source, flags, name, name_loc, operator_loc, location)
    end

    # Create a new LambdaNode node
    def LambdaNode(locals, operator_loc, opening_loc, closing_loc, parameters, body, source = nil, location = Location())
      LambdaNode.new(source, locals, operator_loc, opening_loc, closing_loc, parameters, body, location)
    end

    # Create a new LocalVariableAndWriteNode node
    def LocalVariableAndWriteNode(name_loc, operator_loc, value, name, depth, source = nil, location = Location())
      LocalVariableAndWriteNode.new(source, name_loc, operator_loc, value, name, depth, location)
    end

    # Create a new LocalVariableOperatorWriteNode node
    def LocalVariableOperatorWriteNode(name_loc, binary_operator_loc, value, name, binary_operator, depth, source = nil, location = Location())
      LocalVariableOperatorWriteNode.new(source, name_loc, binary_operator_loc, value, name, binary_operator, depth, location)
    end

    # Create a new LocalVariableOrWriteNode node
    def LocalVariableOrWriteNode(name_loc, operator_loc, value, name, depth, source = nil, location = Location())
      LocalVariableOrWriteNode.new(source, name_loc, operator_loc, value, name, depth, location)
    end

    # Create a new LocalVariableReadNode node
    def LocalVariableReadNode(name, depth, source = nil, location = Location())
      LocalVariableReadNode.new(source, name, depth, location)
    end

    # Create a new LocalVariableTargetNode node
    def LocalVariableTargetNode(name, depth, source = nil, location = Location())
      LocalVariableTargetNode.new(source, name, depth, location)
    end

    # Create a new LocalVariableWriteNode node
    def LocalVariableWriteNode(name, depth, name_loc, value, operator_loc, source = nil, location = Location())
      LocalVariableWriteNode.new(source, name, depth, name_loc, value, operator_loc, location)
    end

    # Create a new MatchLastLineNode node
    def MatchLastLineNode(flags, opening_loc, content_loc, closing_loc, unescaped, source = nil, location = Location())
      MatchLastLineNode.new(source, flags, opening_loc, content_loc, closing_loc, unescaped, location)
    end

    # Create a new MatchPredicateNode node
    def MatchPredicateNode(value, pattern, operator_loc, source = nil, location = Location())
      MatchPredicateNode.new(source, value, pattern, operator_loc, location)
    end

    # Create a new MatchRequiredNode node
    def MatchRequiredNode(value, pattern, operator_loc, source = nil, location = Location())
      MatchRequiredNode.new(source, value, pattern, operator_loc, location)
    end

    # Create a new MatchWriteNode node
    def MatchWriteNode(call, targets, source = nil, location = Location())
      MatchWriteNode.new(source, call, targets, location)
    end

    # Create a new MissingNode node
    def MissingNode(source = nil, location = Location())
      MissingNode.new(source, location)
    end

    # Create a new ModuleNode node
    def ModuleNode(locals, module_keyword_loc, constant_path, body, end_keyword_loc, name, source = nil, location = Location())
      ModuleNode.new(source, locals, module_keyword_loc, constant_path, body, end_keyword_loc, name, location)
    end

    # Create a new MultiTargetNode node
    def MultiTargetNode(lefts, rest, rights, lparen_loc, rparen_loc, source = nil, location = Location())
      MultiTargetNode.new(source, lefts, rest, rights, lparen_loc, rparen_loc, location)
    end

    # Create a new MultiWriteNode node
    def MultiWriteNode(lefts, rest, rights, lparen_loc, rparen_loc, operator_loc, value, source = nil, location = Location())
      MultiWriteNode.new(source, lefts, rest, rights, lparen_loc, rparen_loc, operator_loc, value, location)
    end

    # Create a new NextNode node
    def NextNode(arguments, keyword_loc, source = nil, location = Location())
      NextNode.new(source, arguments, keyword_loc, location)
    end

    # Create a new NilNode node
    def NilNode(source = nil, location = Location())
      NilNode.new(source, location)
    end

    # Create a new NoKeywordsParameterNode node
    def NoKeywordsParameterNode(operator_loc, keyword_loc, source = nil, location = Location())
      NoKeywordsParameterNode.new(source, operator_loc, keyword_loc, location)
    end

    # Create a new NumberedParametersNode node
    def NumberedParametersNode(maximum, source = nil, location = Location())
      NumberedParametersNode.new(source, maximum, location)
    end

    # Create a new NumberedReferenceReadNode node
    def NumberedReferenceReadNode(number, source = nil, location = Location())
      NumberedReferenceReadNode.new(source, number, location)
    end

    # Create a new OptionalKeywordParameterNode node
    def OptionalKeywordParameterNode(flags, name, name_loc, value, source = nil, location = Location())
      OptionalKeywordParameterNode.new(source, flags, name, name_loc, value, location)
    end

    # Create a new OptionalParameterNode node
    def OptionalParameterNode(flags, name, name_loc, operator_loc, value, source = nil, location = Location())
      OptionalParameterNode.new(source, flags, name, name_loc, operator_loc, value, location)
    end

    # Create a new OrNode node
    def OrNode(left, right, operator_loc, source = nil, location = Location())
      OrNode.new(source, left, right, operator_loc, location)
    end

    # Create a new ParametersNode node
    def ParametersNode(requireds, optionals, rest, posts, keywords, keyword_rest, block, source = nil, location = Location())
      ParametersNode.new(source, requireds, optionals, rest, posts, keywords, keyword_rest, block, location)
    end

    # Create a new ParenthesesNode node
    def ParenthesesNode(body, opening_loc, closing_loc, source = nil, location = Location())
      ParenthesesNode.new(source, body, opening_loc, closing_loc, location)
    end

    # Create a new PinnedExpressionNode node
    def PinnedExpressionNode(expression, operator_loc, lparen_loc, rparen_loc, source = nil, location = Location())
      PinnedExpressionNode.new(source, expression, operator_loc, lparen_loc, rparen_loc, location)
    end

    # Create a new PinnedVariableNode node
    def PinnedVariableNode(variable, operator_loc, source = nil, location = Location())
      PinnedVariableNode.new(source, variable, operator_loc, location)
    end

    # Create a new PostExecutionNode node
    def PostExecutionNode(statements, keyword_loc, opening_loc, closing_loc, source = nil, location = Location())
      PostExecutionNode.new(source, statements, keyword_loc, opening_loc, closing_loc, location)
    end

    # Create a new PreExecutionNode node
    def PreExecutionNode(statements, keyword_loc, opening_loc, closing_loc, source = nil, location = Location())
      PreExecutionNode.new(source, statements, keyword_loc, opening_loc, closing_loc, location)
    end

    # Create a new ProgramNode node
    def ProgramNode(locals, statements, source = nil, location = Location())
      ProgramNode.new(source, locals, statements, location)
    end

    # Create a new RangeNode node
    def RangeNode(flags, left, right, operator_loc, source = nil, location = Location())
      RangeNode.new(source, flags, left, right, operator_loc, location)
    end

    # Create a new RationalNode node
    def RationalNode(numeric, source = nil, location = Location())
      RationalNode.new(source, numeric, location)
    end

    # Create a new RedoNode node
    def RedoNode(source = nil, location = Location())
      RedoNode.new(source, location)
    end

    # Create a new RegularExpressionNode node
    def RegularExpressionNode(flags, opening_loc, content_loc, closing_loc, unescaped, source = nil, location = Location())
      RegularExpressionNode.new(source, flags, opening_loc, content_loc, closing_loc, unescaped, location)
    end

    # Create a new RequiredKeywordParameterNode node
    def RequiredKeywordParameterNode(flags, name, name_loc, source = nil, location = Location())
      RequiredKeywordParameterNode.new(source, flags, name, name_loc, location)
    end

    # Create a new RequiredParameterNode node
    def RequiredParameterNode(flags, name, source = nil, location = Location())
      RequiredParameterNode.new(source, flags, name, location)
    end

    # Create a new RescueModifierNode node
    def RescueModifierNode(expression, keyword_loc, rescue_expression, source = nil, location = Location())
      RescueModifierNode.new(source, expression, keyword_loc, rescue_expression, location)
    end

    # Create a new RescueNode node
    def RescueNode(keyword_loc, exceptions, operator_loc, reference, statements, consequent, source = nil, location = Location())
      RescueNode.new(source, keyword_loc, exceptions, operator_loc, reference, statements, consequent, location)
    end

    # Create a new RestParameterNode node
    def RestParameterNode(flags, name, name_loc, operator_loc, source = nil, location = Location())
      RestParameterNode.new(source, flags, name, name_loc, operator_loc, location)
    end

    # Create a new RetryNode node
    def RetryNode(source = nil, location = Location())
      RetryNode.new(source, location)
    end

    # Create a new ReturnNode node
    def ReturnNode(flags, keyword_loc, arguments, source = nil, location = Location())
      ReturnNode.new(source, flags, keyword_loc, arguments, location)
    end

    # Create a new SelfNode node
    def SelfNode(source = nil, location = Location())
      SelfNode.new(source, location)
    end

    # Create a new ShareableConstantNode node
    def ShareableConstantNode(flags, write, source = nil, location = Location())
      ShareableConstantNode.new(source, flags, write, location)
    end

    # Create a new SingletonClassNode node
    def SingletonClassNode(locals, class_keyword_loc, operator_loc, expression, body, end_keyword_loc, source = nil, location = Location())
      SingletonClassNode.new(source, locals, class_keyword_loc, operator_loc, expression, body, end_keyword_loc, location)
    end

    # Create a new SourceEncodingNode node
    def SourceEncodingNode(source = nil, location = Location())
      SourceEncodingNode.new(source, location)
    end

    # Create a new SourceFileNode node
    def SourceFileNode(flags, filepath, source = nil, location = Location())
      SourceFileNode.new(source, flags, filepath, location)
    end

    # Create a new SourceLineNode node
    def SourceLineNode(source = nil, location = Location())
      SourceLineNode.new(source, location)
    end

    # Create a new SplatNode node
    def SplatNode(operator_loc, expression, source = nil, location = Location())
      SplatNode.new(source, operator_loc, expression, location)
    end

    # Create a new StatementsNode node
    def StatementsNode(body, source = nil, location = Location())
      StatementsNode.new(source, body, location)
    end

    # Create a new StringNode node
    def StringNode(flags, opening_loc, content_loc, closing_loc, unescaped, source = nil, location = Location())
      StringNode.new(source, flags, opening_loc, content_loc, closing_loc, unescaped, location)
    end

    # Create a new SuperNode node
    def SuperNode(keyword_loc, lparen_loc, arguments, rparen_loc, block, source = nil, location = Location())
      SuperNode.new(source, keyword_loc, lparen_loc, arguments, rparen_loc, block, location)
    end

    # Create a new SymbolNode node
    def SymbolNode(flags, opening_loc, value_loc, closing_loc, unescaped, source = nil, location = Location())
      SymbolNode.new(source, flags, opening_loc, value_loc, closing_loc, unescaped, location)
    end

    # Create a new TrueNode node
    def TrueNode(source = nil, location = Location())
      TrueNode.new(source, location)
    end

    # Create a new UndefNode node
    def UndefNode(names, keyword_loc, source = nil, location = Location())
      UndefNode.new(source, names, keyword_loc, location)
    end

    # Create a new UnlessNode node
    def UnlessNode(keyword_loc, predicate, then_keyword_loc, statements, consequent, end_keyword_loc, source = nil, location = Location())
      UnlessNode.new(source, keyword_loc, predicate, then_keyword_loc, statements, consequent, end_keyword_loc, location)
    end

    # Create a new UntilNode node
    def UntilNode(flags, keyword_loc, closing_loc, predicate, statements, source = nil, location = Location())
      UntilNode.new(source, flags, keyword_loc, closing_loc, predicate, statements, location)
    end

    # Create a new WhenNode node
    def WhenNode(keyword_loc, conditions, then_keyword_loc, statements, source = nil, location = Location())
      WhenNode.new(source, keyword_loc, conditions, then_keyword_loc, statements, location)
    end

    # Create a new WhileNode node
    def WhileNode(flags, keyword_loc, closing_loc, predicate, statements, source = nil, location = Location())
      WhileNode.new(source, flags, keyword_loc, closing_loc, predicate, statements, location)
    end

    # Create a new XStringNode node
    def XStringNode(flags, opening_loc, content_loc, closing_loc, unescaped, source = nil, location = Location())
      XStringNode.new(source, flags, opening_loc, content_loc, closing_loc, unescaped, location)
    end

    # Create a new YieldNode node
    def YieldNode(keyword_loc, lparen_loc, arguments, rparen_loc, source = nil, location = Location())
      YieldNode.new(source, keyword_loc, lparen_loc, arguments, rparen_loc, location)
    end
  end
end
