/* SKK JISYO TOOLS (SKK dictionary handling tools)
version 1.0 of May 23, 1994
Copyright (C) 1994 Hironobu Takahashi, Masahiko Sato
This file is part of SKK

SKK JISYO TOOLS are free software; you can redistribute them and/or modify
them under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

SKK JISYO TOOLS are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with SKK; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* skkjisyo-sort.c
   Υץ SKK μԤޤ
 */

#include <stdio.h>
#include <malloc.h>

/* ΥץǤϼ򤹤٤ƥɤ߹ߤޤ
   ͤϤ餫Ѱդȡ­ɲä
   ̤ꤷޤޤ꾮ˤ realloc()
   ȯޤ*/

#define STEP (256*1024)

/* ϼΥݥ󥿤ˤäƺ줿˽񤭹ޤޤ */
static unsigned char *dict;
static unsigned int dictsize;

/* ΥǥꥹȤǤ */
static unsigned int *index;

/* ȤǻѤݥ󥿤Ǥ */
static unsigned int *list;
static unsigned int n_line;

/* ɤ߹ߥץ */
static void
readdict()
{
    unsigned int bufsize, incsize;

    dictsize = 0;

    /* ѤΥȤ STEP ХȤѰդޤ */
    dict = malloc(STEP);
    bufsize = STEP;
    incsize = fread(dict+dictsize, 1, bufsize-dictsize, stdin);
    dictsize += incsize;

    /* ⤷դʤ STEP ХȤ䤷ɤ߹ߤ򷫤֤ޤ */
    while (dictsize == bufsize) {
	bufsize += STEP;
	dict = realloc(dict, bufsize);
	incsize = fread(dict+dictsize, 1, bufsize-dictsize, stdin);
	dictsize += incsize;
    }
}

/* ǥ */
static void
make_index()
{
    int i, n;

    n = 0;
    for (i = 0; i < dictsize; ++ i)
	if (dict[i] == '\n')
	    ++ n;
    n_line = n;

    index = malloc((sizeof *index)*(n_line+1));
    n = 0;
    index[0] = 0;
    for (i = 0; i < dictsize; ++ i)
	if (dict[i] == '\n')
	    index[++n] = i+1;

    list = malloc((sizeof *list)*n_line);
    for(i = 0; i < n_line; ++ i)
	list[i] = i;
}

static int
hexcomp(a, b)
     unsigned char *a;
     unsigned char *b;
/* Ȥʸӥ롼
   ʤΥȥǰ a ˤ٤ -1 ֤
   ʳλ 1 ֤ */
{
    while(*a == *b) {
	++a; ++ b;
    }
    if (*a > *b) return 1;
    return -1;
}

static int okuriari(p)
     unsigned char *p;
/* ꤬ʤ뤫ɤȽǤ  0-ʤ 1- */
{
    if ((p[0] & 0x80) == 0) return 0;
    while(*p != ' ')
	if (*p == '\0') return 0; /* 򤬤ʤԤϰ۾Ȥư٤ */
	else            ++ p;
    if (('a' <= p[-1]) && (p[-1] <= 'z')) return 1;
    return 0;
}

int skkcompar(a, b)
     int *a;
     int *b;
/* Ȥӥ롼
    a ˤ٤ -1 ֤ʳλ 1 ֤ */
{
    unsigned char *ptra, *ptrb;
    ptra = dict+index[*a];
    ptrb = dict+index[*b];

    if (okuriari(ptra)) {
	if (okuriari(ptrb))
	    /* 겾̾Τǡa b 򴹤Ӥ */
	    return hexcomp(ptrb, ptra);
	else
	    return -1;  /* a  */
    } else {
	if (okuriari(ptrb))
	    return 1;  /* a  */
	else
	    /* 겾̾ʤΤǡa b 򤽤ΤޤӤ̤֤ */
	    return hexcomp(ptra, ptrb);
    }
}

static void printout()
/* ̤ */
{
    int i;
    unsigned char *ptr, *line;
    int okuriflag;

    puts(";; okuri-ari entries.");
    okuriflag = 1;
    for(i = 0; i < n_line; ++ i) {
	line = dict+index[list[i]];
	if (line[0] == ';') continue; /* ȹԤϽϤʤ */
	if (okuriflag) {
	    if (!okuriari(line)) {
		puts(";; okuri-nasi entries.");
		okuriflag = 0;
	    }
	}
	for (ptr = line; *ptr != '\n'; ++ ptr)
	    putchar(*ptr);
	putchar('\n');
    }
}

int main(argc, argv)
     int argc;
     char **argv;
/* ᥤץ ϻѤޤ */
{
    readdict();
    make_index();
    qsort((char *)list, n_line, sizeof *list, skkcompar);
    printout();
    return 0;
}
