/* skkserv.h
 * SKK Server Version 3.3
 * Copyright (C) 1990 Yukiyoshi Kameyama (kam@sato.riec.tohoku.ac.jp)
 * 
 * Last Updated on 1990/4/28
 * by Yukiyoshi Kameyama (kam@sato.riec.tohoku.ac.jp)
 * Research Institute of Electrical Communication
 * Tohoku University
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either versions 1, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with SKK, see the file COPYING.  If not, write to the Free
 * Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/ioctl.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<netdb.h>

#define DEFAULT_SKK_JISYO "/usr/local/soft/nemacs-3.3/etc/SKK-JISYO.L"	
					/* default jisho name */
#define SERVICE_NAME	"skkserv"	/* service name */
/*
 * if you don't want to use getservbyname(), uncomment the following line
 * #define PORTNUM	1178
 */

#define	MAXQUE		5
#define MAXDTAB		getdtablesize()	
				/* max number of file descriptors */
				/* it returns 64 on SunOS 4.x & NEWS OS 3.3 */
				/* it returns 30 on SunOS 3.x & NEWS OS 2.2 */
				/* 20 is guaranteed value on all machines */
#define MAXCLNT		64	/* max number of clients */
#define	BUFSIZE		512	/* max length of one line of jisho */
#define KANAMOJI	100	/* number of KANA moji */

/*
 * bit-operation in select
 */
#ifndef FD_SET
#define	NFDBITS	(sizeof(long) * 8)
#define	FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define	FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define	FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define	FD_ZERO(p)	bzero((char *)(p), sizeof(*(p)))
#endif

