/**********************************/
/* This file is part of QtC 0.0.2 */
/* (c) 1997 Roberto Alsina        */
/* Licensed under the GPL v2      */
/* Read file COPYING for details  */
/**********************************/
#include "qt_QString.h"

qt_QString *qt_new_QString()

{
	return (qt_QString *) new QString( );
}

qt_QString *qt_new_QString1(int size)

{
	return (qt_QString *) new QString( (int)size );
}

qt_QString *qt_new_QString2(qt_QString * s)

{
	return (qt_QString *) new QString( (QString&)*s );
}

qt_QString *qt_new_QString3(char* str)

{
	return (qt_QString *) new QString( (char*)str );
}

qt_QString *qt_new_QString4(char* str,unsigned int maxlen)

{
	return (qt_QString *) new QString( (char*)str,(uint)maxlen );
}

void qt_del_QString (qt_QString *p)
{
delete (QString*) p;
}

int qt_QString_isNull( qt_QString *instPointer){
	return (int)((QString *)instPointer)->isNull();
}
int qt_QString_isEmpty( qt_QString *instPointer){
	return (int)((QString *)instPointer)->isEmpty();
}
unsigned int qt_QString_length( qt_QString *instPointer){
	return (unsigned int)((QString *)instPointer)->length();
}
int qt_QString_resize( qt_QString *instPointer,unsigned int newlen){
	return (int)((QString *)instPointer)->resize((uint )newlen);
}
int qt_QString_truncate( qt_QString *instPointer,unsigned int pos){
	return (int)((QString *)instPointer)->truncate((uint )pos);
}
int qt_QString_fill( qt_QString *instPointer,char c,int len){
	return (int)((QString *)instPointer)->fill((char )c,(int )len);
}
qt_QString * qt_QString_copy( qt_QString *instPointer){
	return (qt_QString *)new QString(((QString *)instPointer)->copy());
}


/**************************************/
/*This function didn't wrap*/
/*qt_QString * qt_QString_sprintf( qt_QString *instPointer,char* format,XXX arg1){*/
/*	return (qt_QString *)((QString *)instPointer)->sprintf((char* )format,(... )arg1);*/
/*}*/
/**/

int qt_QString_find( qt_QString *instPointer,char c,int index,int cs){
	return (int)((QString *)instPointer)->find((char )c,(int )index,(bool )cs);
}
int qt_QString_find1( qt_QString *instPointer,char* str,int index,int cs){
	return (int)((QString *)instPointer)->find((char* )str,(int )index,(bool )cs);
}
int qt_QString_find2( qt_QString *instPointer,qt_QRegExp * arg1,int index){
	return (int)((QString *)instPointer)->find((QRegExp& )*arg1,(int )index);
}
int qt_QString_findRev( qt_QString *instPointer,char c,int index,int cs){
	return (int)((QString *)instPointer)->findRev((char )c,(int )index,(bool )cs);
}
int qt_QString_findRev1( qt_QString *instPointer,char* str,int index,int cs){
	return (int)((QString *)instPointer)->findRev((char* )str,(int )index,(bool )cs);
}
int qt_QString_findRev2( qt_QString *instPointer,qt_QRegExp * arg1,int index){
	return (int)((QString *)instPointer)->findRev((QRegExp& )*arg1,(int )index);
}
int qt_QString_contains( qt_QString *instPointer,char c,int cs){
	return (int)((QString *)instPointer)->contains((char )c,(bool )cs);
}
int qt_QString_contains1( qt_QString *instPointer,char* str,int cs){
	return (int)((QString *)instPointer)->contains((char* )str,(bool )cs);
}
int qt_QString_contains2( qt_QString *instPointer,qt_QRegExp * arg1){
	return (int)((QString *)instPointer)->contains((QRegExp& )*arg1);
}
qt_QString * qt_QString_left( qt_QString *instPointer,unsigned int len){
	return (qt_QString *)new QString(((QString *)instPointer)->left((uint )len));
}
qt_QString * qt_QString_right( qt_QString *instPointer,unsigned int len){
	return (qt_QString *)new QString(((QString *)instPointer)->right((uint )len));
}
qt_QString * qt_QString_mid( qt_QString *instPointer,unsigned int index,unsigned int len){
	return (qt_QString *)new QString(((QString *)instPointer)->mid((uint )index,(uint )len));
}
qt_QString * qt_QString_leftJustify( qt_QString *instPointer,unsigned int width,char fill,int trunc){
	return (qt_QString *)new QString(((QString *)instPointer)->leftJustify((uint )width,(char )fill,(bool )trunc));
}
qt_QString * qt_QString_rightJustify( qt_QString *instPointer,unsigned int width,char fill,int trunc){
	return (qt_QString *)new QString(((QString *)instPointer)->rightJustify((uint )width,(char )fill,(bool )trunc));
}
qt_QString * qt_QString_lower( qt_QString *instPointer){
	return (qt_QString *)new QString(((QString *)instPointer)->lower());
}
qt_QString * qt_QString_upper( qt_QString *instPointer){
	return (qt_QString *)new QString(((QString *)instPointer)->upper());
}
qt_QString * qt_QString_stripWhiteSpace( qt_QString *instPointer){
	return (qt_QString *)new QString(((QString *)instPointer)->stripWhiteSpace());
}
qt_QString * qt_QString_simplifyWhiteSpace( qt_QString *instPointer){
	return (qt_QString *)new QString(((QString *)instPointer)->simplifyWhiteSpace());
}
qt_QString * qt_QString_insert( qt_QString *instPointer,unsigned int index,char* arg1){
	return (qt_QString *)new QString(((QString *)instPointer)->insert((uint )index,(char* )arg1));
}
qt_QString * qt_QString_insert1( qt_QString *instPointer,unsigned int index,char arg1){
	return (qt_QString *)new QString(((QString *)instPointer)->insert((uint )index,(char )arg1));
}
qt_QString * qt_QString_append( qt_QString *instPointer,char* arg1){
	return (qt_QString *)new QString(((QString *)instPointer)->append((char* )arg1));
}
qt_QString * qt_QString_prepend( qt_QString *instPointer,char* arg1){
	return (qt_QString *)new QString(((QString *)instPointer)->prepend((char* )arg1));
}
qt_QString * qt_QString_remove( qt_QString *instPointer,unsigned int index,unsigned int len){
	return (qt_QString *)new QString(((QString *)instPointer)->remove((uint )index,(uint )len));
}
qt_QString * qt_QString_replace( qt_QString *instPointer,unsigned int index,unsigned int len,char* arg1){
	return (qt_QString *)new QString(((QString *)instPointer)->replace((uint )index,(uint )len,(char* )arg1));
}
qt_QString * qt_QString_replace1( qt_QString *instPointer,qt_QRegExp * arg1,char* arg2){
	return (qt_QString *)new QString(((QString *)instPointer)->replace((QRegExp& )*arg1,(char* )arg2));
}
short int qt_QString_toShort( qt_QString *instPointer,int* ok){
	return (short int)((QString *)instPointer)->toShort((bool* )ok);
}
unsigned short int qt_QString_toUShort( qt_QString *instPointer,int* ok){
	return (unsigned short int)((QString *)instPointer)->toUShort((bool* )ok);
}
int qt_QString_toInt( qt_QString *instPointer,int* ok){
	return (int)((QString *)instPointer)->toInt((bool* )ok);
}
unsigned int qt_QString_toUInt( qt_QString *instPointer,int* ok){
	return (unsigned int)((QString *)instPointer)->toUInt((bool* )ok);
}
long qt_QString_toLong( qt_QString *instPointer,int* ok){
	return (long)((QString *)instPointer)->toLong((bool* )ok);
}
unsigned long qt_QString_toULong( qt_QString *instPointer,int* ok){
	return (unsigned long)((QString *)instPointer)->toULong((bool* )ok);
}
float qt_QString_toFloat( qt_QString *instPointer,int* ok){
	return (float)((QString *)instPointer)->toFloat((bool* )ok);
}
double qt_QString_toDouble( qt_QString *instPointer,int* ok){
	return (double)((QString *)instPointer)->toDouble((bool* )ok);
}
qt_QString * qt_QString_setStr( qt_QString *instPointer,char* s){
	return (qt_QString *)new QString(((QString *)instPointer)->setStr((char* )s));
}
qt_QString * qt_QString_setNum( qt_QString *instPointer,short int arg1){
	return (qt_QString *)new QString(((QString *)instPointer)->setNum((short )arg1));
}
qt_QString * qt_QString_setNum1( qt_QString *instPointer,unsigned short int arg1){
	return (qt_QString *)new QString(((QString *)instPointer)->setNum((ushort )arg1));
}
qt_QString * qt_QString_setNum2( qt_QString *instPointer,int arg1){
	return (qt_QString *)new QString(((QString *)instPointer)->setNum((int )arg1));
}
qt_QString * qt_QString_setNum3( qt_QString *instPointer,unsigned int arg1){
	return (qt_QString *)new QString(((QString *)instPointer)->setNum((uint )arg1));
}
qt_QString * qt_QString_setNum4( qt_QString *instPointer,long arg1){
	return (qt_QString *)new QString(((QString *)instPointer)->setNum((long )arg1));
}
qt_QString * qt_QString_setNum5( qt_QString *instPointer,unsigned long arg1){
	return (qt_QString *)new QString(((QString *)instPointer)->setNum((ulong )arg1));
}
qt_QString * qt_QString_setNum6( qt_QString *instPointer,float arg1,char f,int prec){
	return (qt_QString *)new QString(((QString *)instPointer)->setNum((float )arg1,(char )f,(int )prec));
}
qt_QString * qt_QString_setNum7( qt_QString *instPointer,double arg1,char f,int prec){
	return (qt_QString *)new QString(((QString *)instPointer)->setNum((double )arg1,(char )f,(int )prec));
}
int qt_QString_setExpand( qt_QString *instPointer,unsigned int index,char c){
	return (int)((QString *)instPointer)->setExpand((uint )index,(char )c);
}
char *qt_QString_data(qt_QString *s)
{
    return ((QString *)s)->data();
}
