/**********************************/
/* This file is part of QtC 0.0.2 */
/* (c) 1997 Roberto Alsina        */
/* Licensed under the GPL v2      */
/* Read file COPYING for details  */
/**********************************/
#include "qt_QImage.h"

qt_QImage *qt_new_QImage(){
	return (qt_QImage *)new QImage();
}
qt_QImage *qt_new_QImage1(int width,int height,int depth,int numColors,int bitOrder)

{
    return (qt_QImage *) new QImage( (int)width,(int)height,(int)depth,(int)numColors,(QImage::Endian)bitOrder );
}

qt_QImage *qt_new_QImage2(qt_QSize * arg1,int depth,int numColors,int bitOrder)

{
    return (qt_QImage *) new QImage( (QSize&)*arg1,(int)depth,(int)numColors,(QImage::Endian)bitOrder );
}

qt_QImage *qt_new_QImage3(char* fileName,char* format)

{
	return (qt_QImage *) new QImage( (char*)fileName,(char*)format );
}

qt_QImage *qt_new_QImage4(char* xpm[])

{
	return (qt_QImage *) new QImage((const char *)xpm);
}

qt_QImage *qt_new_QImage5(qt_QImage * arg1)

{
	return (qt_QImage *) new QImage( (QImage&)*arg1 );
}

void qt_del_QImage (qt_QImage *p)
{
delete (QImage*) p;
}

void qt_QImage_detach( qt_QImage *instPointer){
	((QImage *)instPointer)->detach();
}
qt_QImage * qt_QImage_copy( qt_QImage *instPointer){
	return (qt_QImage *)new QImage(((QImage *)instPointer)->copy());
}
int qt_QImage_isNull( qt_QImage *instPointer){
	return (int)((QImage *)instPointer)->isNull();
}
int qt_QImage_width( qt_QImage *instPointer){
	return (int)((QImage *)instPointer)->width();
}
int qt_QImage_height( qt_QImage *instPointer){
	return (int)((QImage *)instPointer)->height();
}
qt_QSize * qt_QImage_size( qt_QImage *instPointer){
    QSize s=((QImage *)instPointer)->size();
    return (qt_QSize *)new QSize(s.width(),s.height());
}
qt_QRect * qt_QImage_rect( qt_QImage *instPointer){
    QRect r=((QImage *)instPointer)->rect();
    return (qt_QRect *)new QRect (r.left(),r.top(),r.width(),r.height());
}
int qt_QImage_depth( qt_QImage *instPointer){
	return (int)((QImage *)instPointer)->depth();
}
int qt_QImage_numColors( qt_QImage *instPointer){
	return (int)((QImage *)instPointer)->numColors();
}
int qt_QImage_bitOrder( qt_QImage *instPointer){
	return (int)((QImage *)instPointer)->bitOrder();
}
unsigned int qt_QImage_color( qt_QImage *instPointer,int i){
	return (unsigned int)((QImage *)instPointer)->color((int )i);
}
void qt_QImage_setColor( qt_QImage *instPointer,int i,unsigned int c){
	((QImage *)instPointer)->setColor((int )i,(QRgb )c);
}
void qt_QImage_setNumColors( qt_QImage *instPointer,int arg1){
	((QImage *)instPointer)->setNumColors((int )arg1);
}
int qt_QImage_hasAlphaBuffer( qt_QImage *instPointer){
	return (int)((QImage *)instPointer)->hasAlphaBuffer();
}
void qt_QImage_setAlphaBuffer( qt_QImage *instPointer,int arg1){
	((QImage *)instPointer)->setAlphaBuffer((bool )arg1);
}
unsigned char* qt_QImage_bits( qt_QImage *instPointer){
	return (unsigned char*)((QImage *)instPointer)->bits();
}
unsigned char* qt_QImage_scanLine( qt_QImage *instPointer,int arg1){
	return (unsigned char*)((QImage *)instPointer)->scanLine((int )arg1);
}
unsigned char** qt_QImage_jumpTable( qt_QImage *instPointer){
	return (unsigned char**)((QImage *)instPointer)->jumpTable();
}
unsigned int * qt_QImage_colorTable( qt_QImage *instPointer){
	return (unsigned int *)((QImage *)instPointer)->colorTable();
}
int qt_QImage_numBytes( qt_QImage *instPointer){
	return (int)((QImage *)instPointer)->numBytes();
}
int qt_QImage_bytesPerLine( qt_QImage *instPointer){
	return (int)((QImage *)instPointer)->bytesPerLine();
}
int qt_QImage_create( qt_QImage *instPointer,int width,int height,int depth,int numColors,int bitOrder){
	return (int)((QImage *)instPointer)->create((int )width,(int )height,(int )depth,(int )numColors,(Endian )bitOrder);
}
int qt_QImage_create1( qt_QImage *instPointer,qt_QSize * arg1,int depth,int numColors,int bitOrder){
	return (int)((QImage *)instPointer)->create((QSize& )*arg1,(int )depth,(int )numColors,(Endian )bitOrder);
}
void qt_QImage_reset( qt_QImage *instPointer){
	((QImage *)instPointer)->reset();
}
void qt_QImage_fill( qt_QImage *instPointer,unsigned int pixel){
	((QImage *)instPointer)->fill((uint )pixel);
}
qt_QImage * qt_QImage_convertDepth( qt_QImage *instPointer,int arg1){
	return (qt_QImage *)new QImage(((QImage *)instPointer)->convertDepth((int )arg1));
}
qt_QImage * qt_QImage_convertDepth1( qt_QImage *instPointer,int arg1,int conversion_flags){
	return (qt_QImage *)new QImage(((QImage *)instPointer)->convertDepth((int )arg1,(int )conversion_flags));
}
qt_QImage * qt_QImage_convertBitOrder( qt_QImage *instPointer,int arg1){
	return (qt_QImage *)new QImage(((QImage *)instPointer)->convertBitOrder((Endian )arg1));
}
qt_QImage * qt_QImage_createAlphaMask( qt_QImage *instPointer){
	return (qt_QImage *)new QImage(((QImage *)instPointer)->createAlphaMask());
}
qt_QImage * qt_QImage_createAlphaMask1( qt_QImage *instPointer,int conversion_flags){
	return (qt_QImage *)new QImage(((QImage *)instPointer)->createAlphaMask((int )conversion_flags));
}
qt_QImage * qt_QImage_createHeuristicMask( qt_QImage *instPointer,int clipTight){
	return (qt_QImage *)new QImage(((QImage *)instPointer)->createHeuristicMask((bool )clipTight));
}
int qt_QImage_systemBitOrder()
{
	return (int)QImage::systemBitOrder();
}
int qt_QImage_systemByteOrder()
{
	return (int)QImage::systemByteOrder();
}
char* qt_QImage_imageFormat( char* fileName)
{
	return (char*)QImage::imageFormat( (char*)fileName);
}
/*qt_QStrList * qt_QImage_inputFormats()
{
	return (qt_QStrList *)QImage::inputFormats();
}
qt_QStrList * qt_QImage_outputFormats()
{
	return (qt_QStrList *)QImage::outputFormats();
} */
int qt_QImage_load( qt_QImage *instPointer,char* fileName,char* format){
	return (int)((QImage *)instPointer)->load((char* )fileName,(char* )format);
}
int qt_QImage_loadFromData( qt_QImage *instPointer,unsigned char* buf,unsigned int len,char* format){
	return (int)((QImage *)instPointer)->loadFromData((uchar* )buf,(uint )len,(char* )format);
}
int qt_QImage_save( qt_QImage *instPointer,char* fileName,char* format){
	return (int)((QImage *)instPointer)->save((char* )fileName,(char* )format);
}
int qt_QImage_valid( qt_QImage *instPointer,int x,int y){
	return (int)((QImage *)instPointer)->valid((int )x,(int )y);
}
int qt_QImage_pixelIndex( qt_QImage *instPointer,int x,int y){
	return (int)((QImage *)instPointer)->pixelIndex((int )x,(int )y);
}
unsigned int qt_QImage_pixel( qt_QImage *instPointer,int x,int y){
	return (unsigned int)((QImage *)instPointer)->pixel((int )x,(int )y);
}
void qt_QImage_setPixel( qt_QImage *instPointer,int x,int y,unsigned int index_or_rgb){
	((QImage *)instPointer)->setPixel((int )x,(int )y,(uint )index_or_rgb);
}
