/**********************************/
/* This file is part of QtC 0.0.2 */
/* (c) 1997 Roberto Alsina        */
/* Licensed under the GPL v2      */
/* Read file COPYING for details  */
/**********************************/
#include "qt_QDateTime.h"

qt_QDateTime *qt_new_QDateTime()

{
	return (qt_QDateTime *) new QDateTime( );
}

qt_QDateTime *qt_new_QDateTime1(qt_QDate * arg1)

{
	return (qt_QDateTime *) new QDateTime( (QDate&)*arg1 );
}

qt_QDateTime *qt_new_QDateTime2(qt_QDate * arg1,qt_QTime * arg2)

{
	return (qt_QDateTime *) new QDateTime( (QDate&)*arg1,(QTime&)*arg2 );
}

void qt_del_QDateTime (qt_QDateTime *p)
{
delete (QDateTime*) p;
}

int qt_QDateTime_isNull( qt_QDateTime *instPointer){
	return (int)((QDateTime *)instPointer)->isNull();
}
int qt_QDateTime_isValid( qt_QDateTime *instPointer){
	return (int)((QDateTime *)instPointer)->isValid();
}
qt_QDate * qt_QDateTime_date( qt_QDateTime *instPointer){
    QDate d=((QDateTime *)instPointer)->date();
    return (qt_QDate *)new QDate(d.year(),d.month(),d.day());
}
qt_QTime * qt_QDateTime_time( qt_QDateTime *instPointer){
    QTime t=((QDateTime *)instPointer)->time();
    return (qt_QTime *)new QTime (t.hour(),t.minute(),t.second(),t.msec());
}
void qt_QDateTime_setDate( qt_QDateTime *instPointer,qt_QDate * date){
	((QDateTime *)instPointer)->setDate((QDate&)*date);
}
void qt_QDateTime_setTime( qt_QDateTime *instPointer,qt_QTime * time){
	((QDateTime *)instPointer)->setTime((QTime&)*time);
}
void qt_QDateTime_setTime_t( qt_QDateTime *instPointer,unsigned int secsSince1Jan1970UTC){
	((QDateTime *)instPointer)->setTime_t((uint )secsSince1Jan1970UTC);
}
qt_QString * qt_QDateTime_toString( qt_QDateTime *instPointer){
	return (qt_QString *)new QString(((QDateTime *)instPointer)->toString());
}
qt_QDateTime * qt_QDateTime_addDays( qt_QDateTime *instPointer,int days){
    QDateTime dt=((QDateTime *)instPointer)->addDays((int )days);
    return (qt_QDateTime *)new QDateTime (dt.date(),dt.time());
}
qt_QDateTime * qt_QDateTime_addSecs( qt_QDateTime *instPointer,int secs){
    QDateTime dt=((QDateTime *)instPointer)->addSecs((int )secs);
    return (qt_QDateTime *)new QDateTime (dt.date(),dt.time());
}
int qt_QDateTime_daysTo( qt_QDateTime *instPointer,qt_QDateTime * arg1){
	return (int)((QDateTime *)instPointer)->daysTo((QDateTime&)*arg1);
}
int qt_QDateTime_secsTo( qt_QDateTime *instPointer,qt_QDateTime * arg1){
	return (int)((QDateTime *)instPointer)->secsTo((QDateTime&)*arg1);
}
qt_QDateTime * qt_QDateTime_currentDateTime()
{
    QDateTime dt=QDateTime::currentDateTime();
    return (qt_QDateTime *)new QDateTime (dt.date(),dt.time());
}
