/* rygel-free-desktop-interfaces.c generated by valac 0.9.6, the Vala compiler
 * generated from rygel-free-desktop-interfaces.vala, do not modify */

/*
 * Copyright (C) 2009,2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus.h>


#define FREE_DESKTOP_TYPE_DBUS_OBJECT (free_desktop_dbus_object_get_type ())
#define FREE_DESKTOP_DBUS_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FREE_DESKTOP_TYPE_DBUS_OBJECT, FreeDesktopDBusObject))
#define FREE_DESKTOP_IS_DBUS_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FREE_DESKTOP_TYPE_DBUS_OBJECT))
#define FREE_DESKTOP_DBUS_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FREE_DESKTOP_TYPE_DBUS_OBJECT, FreeDesktopDBusObjectIface))

typedef struct _FreeDesktopDBusObject FreeDesktopDBusObject;
typedef struct _FreeDesktopDBusObjectIface FreeDesktopDBusObjectIface;
typedef struct _DBusObjectVTable _DBusObjectVTable;
typedef struct _FreeDesktopDBusObjectDBusProxy FreeDesktopDBusObjectDBusProxy;
typedef DBusGProxyClass FreeDesktopDBusObjectDBusProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _FreeDesktopDBusObjectDBusProxyListNamesData FreeDesktopDBusObjectDBusProxyListNamesData;
typedef struct _FreeDesktopDBusObjectDBusProxyListActivatableNamesData FreeDesktopDBusObjectDBusProxyListActivatableNamesData;

#define FREE_DESKTOP_TYPE_PROPERTIES (free_desktop_properties_get_type ())
#define FREE_DESKTOP_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FREE_DESKTOP_TYPE_PROPERTIES, FreeDesktopProperties))
#define FREE_DESKTOP_IS_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FREE_DESKTOP_TYPE_PROPERTIES))
#define FREE_DESKTOP_PROPERTIES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FREE_DESKTOP_TYPE_PROPERTIES, FreeDesktopPropertiesIface))

typedef struct _FreeDesktopProperties FreeDesktopProperties;
typedef struct _FreeDesktopPropertiesIface FreeDesktopPropertiesIface;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _FreeDesktopPropertiesDBusProxy FreeDesktopPropertiesDBusProxy;
typedef DBusGProxyClass FreeDesktopPropertiesDBusProxyClass;
typedef struct _FreeDesktopPropertiesDBusProxyGetAllData FreeDesktopPropertiesDBusProxyGetAllData;

struct _FreeDesktopDBusObjectIface {
	GTypeInterface parent_iface;
	void (*list_names) (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char** (*list_names_finish) (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*list_activatable_names) (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char** (*list_activatable_names_finish) (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _FreeDesktopDBusObjectDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _FreeDesktopDBusObjectDBusProxyListNamesData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _FreeDesktopDBusObjectDBusProxyListActivatableNamesData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _FreeDesktopPropertiesIface {
	GTypeInterface parent_iface;
	void (*get_all) (FreeDesktopProperties* self, const char* iface, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable* (*get_all_finish) (FreeDesktopProperties* self, GAsyncResult* _res_, GError** error);
};

struct _FreeDesktopPropertiesDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _FreeDesktopPropertiesDBusProxyGetAllData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};



FreeDesktopDBusObject* free_desktop_dbus_object_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType free_desktop_dbus_object_get_type (void) G_GNUC_CONST;
void free_desktop_dbus_object_list_names (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
char** free_desktop_dbus_object_list_names_finish (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
void free_desktop_dbus_object_list_activatable_names (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
char** free_desktop_dbus_object_list_activatable_names_finish (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void free_desktop_dbus_object_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _free_desktop_dbus_object_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult free_desktop_dbus_object_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_free_desktop_dbus_object_introspect (FreeDesktopDBusObject* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_free_desktop_dbus_object_property_get_all (FreeDesktopDBusObject* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_free_desktop_dbus_object_list_names (FreeDesktopDBusObject* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_free_desktop_dbus_object_list_names_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
static DBusHandlerResult _dbus_free_desktop_dbus_object_list_activatable_names (FreeDesktopDBusObject* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_free_desktop_dbus_object_list_activatable_names_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
static void _dbus_free_desktop_dbus_object_name_owner_changed (GObject* _sender, const char* name, const char* old_owner, const char* new_owner, DBusConnection* _connection);
GType free_desktop_dbus_object_dbus_proxy_get_type (void) G_GNUC_CONST;
static void _dbus_handle_free_desktop_dbus_object_name_owner_changed (FreeDesktopDBusObject* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult free_desktop_dbus_object_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	FREE_DESKTOP_DBUS_OBJECT_DBUS_PROXY_DUMMY_PROPERTY
};
static void free_desktop_dbus_object_dbus_proxy_list_names_async (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void free_desktop_dbus_object_dbus_proxy_list_names_ready (DBusPendingCall* pending, void* user_data);
static char** free_desktop_dbus_object_dbus_proxy_list_names_finish (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void free_desktop_dbus_object_dbus_proxy_list_activatable_names_async (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void free_desktop_dbus_object_dbus_proxy_list_activatable_names_ready (DBusPendingCall* pending, void* user_data);
static char** free_desktop_dbus_object_dbus_proxy_list_activatable_names_finish (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void free_desktop_dbus_object_dbus_proxy_free_desktop_dbus_object__interface_init (FreeDesktopDBusObjectIface* iface);
static void free_desktop_dbus_object_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void free_desktop_dbus_object_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
FreeDesktopProperties* free_desktop_properties_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType free_desktop_properties_get_type (void) G_GNUC_CONST;
void free_desktop_properties_get_all (FreeDesktopProperties* self, const char* iface, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable* free_desktop_properties_get_all_finish (FreeDesktopProperties* self, GAsyncResult* _res_, GError** error);
void free_desktop_properties_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _free_desktop_properties_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult free_desktop_properties_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_free_desktop_properties_introspect (FreeDesktopProperties* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_free_desktop_properties_property_get_all (FreeDesktopProperties* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_free_desktop_properties_get_all (FreeDesktopProperties* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_free_desktop_properties_get_all_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
static void _dbus_free_desktop_properties_properties_changed (GObject* _sender, const char* iface, GHashTable* changed, char** invalidated, int invalidated_length1, DBusConnection* _connection);
GType free_desktop_properties_dbus_proxy_get_type (void) G_GNUC_CONST;
static void _dbus_handle_free_desktop_properties_properties_changed (FreeDesktopProperties* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult free_desktop_properties_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	FREE_DESKTOP_PROPERTIES_DBUS_PROXY_DUMMY_PROPERTY
};
static void free_desktop_properties_dbus_proxy_get_all_async (FreeDesktopProperties* self, const char* iface, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void free_desktop_properties_dbus_proxy_get_all_ready (DBusPendingCall* pending, void* user_data);
static GHashTable* free_desktop_properties_dbus_proxy_get_all_finish (FreeDesktopProperties* self, GAsyncResult* _res_, GError** error);
static void free_desktop_properties_dbus_proxy_free_desktop_properties__interface_init (FreeDesktopPropertiesIface* iface);
static void free_desktop_properties_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void free_desktop_properties_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const DBusObjectPathVTable _free_desktop_dbus_object_dbus_path_vtable = {_free_desktop_dbus_object_dbus_unregister, free_desktop_dbus_object_dbus_message};
static const _DBusObjectVTable _free_desktop_dbus_object_dbus_vtable = {free_desktop_dbus_object_dbus_register_object};
static const DBusObjectPathVTable _free_desktop_properties_dbus_path_vtable = {_free_desktop_properties_dbus_unregister, free_desktop_properties_dbus_message};
static const _DBusObjectVTable _free_desktop_properties_dbus_vtable = {free_desktop_properties_dbus_register_object};

static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_BOXED_BOXED_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

#line 26 "rygel-volume.vala"
void free_desktop_dbus_object_list_names (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 26 "rygel-volume.vala"
	FREE_DESKTOP_DBUS_OBJECT_GET_INTERFACE (self)->list_names (self, _callback_, _user_data_);
#line 184 "rygel-free-desktop-interfaces.c"
}


#line 26 "rygel-volume.vala"
char** free_desktop_dbus_object_list_names_finish (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error) {
#line 26 "rygel-volume.vala"
	return FREE_DESKTOP_DBUS_OBJECT_GET_INTERFACE (self)->list_names_finish (self, _res_, result_length1, error);
#line 192 "rygel-free-desktop-interfaces.c"
}


#line 26 "rygel-volume.vala"
void free_desktop_dbus_object_list_activatable_names (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 26 "rygel-volume.vala"
	FREE_DESKTOP_DBUS_OBJECT_GET_INTERFACE (self)->list_activatable_names (self, _callback_, _user_data_);
#line 200 "rygel-free-desktop-interfaces.c"
}


#line 26 "rygel-volume.vala"
char** free_desktop_dbus_object_list_activatable_names_finish (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error) {
#line 26 "rygel-volume.vala"
	return FREE_DESKTOP_DBUS_OBJECT_GET_INTERFACE (self)->list_activatable_names_finish (self, _res_, result_length1, error);
#line 208 "rygel-free-desktop-interfaces.c"
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _free_desktop_dbus_object_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_free_desktop_dbus_object_introspect (FreeDesktopDBusObject* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus\">\n  <method name=\"ListNames\">\n    <arg name=\"result\" type=\"as\" direction=\"out\"/>\n  </method>\n  <method name=\"ListActivatableNames\">\n    <arg name=\"result\" type=\"as\" direction=\"out\"/>\n  </method>\n  <signal name=\"NameOwnerChanged\">\n    <arg name=\"name\" type=\"s\"/>\n    <arg name=\"old_owner\" type=\"s\"/>\n    <arg name=\"new_owner\" type=\"s\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_free_desktop_dbus_object_property_get_all (FreeDesktopDBusObject* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "org.freedesktop.DBus") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_free_desktop_dbus_object_list_names (FreeDesktopDBusObject* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	free_desktop_dbus_object_list_names (self, (GAsyncReadyCallback) _dbus_free_desktop_dbus_object_list_names_ready, _user_data_);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_free_desktop_dbus_object_list_names_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	char** result;
	int result_length1;
	DBusMessage* reply;
	char** _tmp1_;
	DBusMessageIter _tmp2_;
	int _tmp3_;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	result_length1 = 0;
	result = free_desktop_dbus_object_list_names_finish ((FreeDesktopDBusObject*) source_object, _res_, &result_length1, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp1_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "s", &_tmp2_);
	for (_tmp3_ = 0; _tmp3_ < result_length1; _tmp3_++) {
		const char* _tmp4_;
		_tmp4_ = *_tmp1_;
		dbus_message_iter_append_basic (&_tmp2_, DBUS_TYPE_STRING, &_tmp4_);
		_tmp1_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp2_);
	result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


static DBusHandlerResult _dbus_free_desktop_dbus_object_list_activatable_names (FreeDesktopDBusObject* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	free_desktop_dbus_object_list_activatable_names (self, (GAsyncReadyCallback) _dbus_free_desktop_dbus_object_list_activatable_names_ready, _user_data_);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_free_desktop_dbus_object_list_activatable_names_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	char** result;
	int result_length1;
	DBusMessage* reply;
	char** _tmp5_;
	DBusMessageIter _tmp6_;
	int _tmp7_;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	result_length1 = 0;
	result = free_desktop_dbus_object_list_activatable_names_finish ((FreeDesktopDBusObject*) source_object, _res_, &result_length1, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp5_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "s", &_tmp6_);
	for (_tmp7_ = 0; _tmp7_ < result_length1; _tmp7_++) {
		const char* _tmp8_;
		_tmp8_ = *_tmp5_;
		dbus_message_iter_append_basic (&_tmp6_, DBUS_TYPE_STRING, &_tmp8_);
		_tmp5_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp6_);
	result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


DBusHandlerResult free_desktop_dbus_object_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_free_desktop_dbus_object_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_free_desktop_dbus_object_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus", "ListNames")) {
		result = _dbus_free_desktop_dbus_object_list_names (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus", "ListActivatableNames")) {
		result = _dbus_free_desktop_dbus_object_list_activatable_names (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_free_desktop_dbus_object_name_owner_changed (GObject* _sender, const char* name, const char* old_owner, const char* new_owner, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	const char* _tmp9_;
	const char* _tmp10_;
	const char* _tmp11_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.freedesktop.DBus", "NameOwnerChanged");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp9_ = name;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp9_);
	_tmp10_ = old_owner;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp10_);
	_tmp11_ = new_owner;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp11_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void free_desktop_dbus_object_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_free_desktop_dbus_object_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "name-owner-changed", (GCallback) _dbus_free_desktop_dbus_object_name_owner_changed, connection);
}


static void free_desktop_dbus_object_base_init (FreeDesktopDBusObjectIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("name_owner_changed", FREE_DESKTOP_TYPE_DBUS_OBJECT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
		g_type_set_qdata (FREE_DESKTOP_TYPE_DBUS_OBJECT, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_free_desktop_dbus_object_dbus_vtable));
	}
}


GType free_desktop_dbus_object_get_type (void) {
	static volatile gsize free_desktop_dbus_object_type_id__volatile = 0;
	if (g_once_init_enter (&free_desktop_dbus_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FreeDesktopDBusObjectIface), (GBaseInitFunc) free_desktop_dbus_object_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType free_desktop_dbus_object_type_id;
		free_desktop_dbus_object_type_id = g_type_register_static (G_TYPE_INTERFACE, "FreeDesktopDBusObject", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (free_desktop_dbus_object_type_id, DBUS_TYPE_G_PROXY);
		g_type_set_qdata (free_desktop_dbus_object_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &free_desktop_dbus_object_dbus_proxy_get_type);
		g_once_init_leave (&free_desktop_dbus_object_type_id__volatile, free_desktop_dbus_object_type_id);
	}
	return free_desktop_dbus_object_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (FreeDesktopDBusObjectDBusProxy, free_desktop_dbus_object_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (FREE_DESKTOP_TYPE_DBUS_OBJECT, free_desktop_dbus_object_dbus_proxy_free_desktop_dbus_object__interface_init) );
FreeDesktopDBusObject* free_desktop_dbus_object_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	FreeDesktopDBusObject* self;
	self = g_object_new (free_desktop_dbus_object_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.DBus", NULL);
	return self;
}


static GObject* free_desktop_dbus_object_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (free_desktop_dbus_object_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), free_desktop_dbus_object_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_free_desktop_dbus_object_name_owner_changed (FreeDesktopDBusObject* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* name = NULL;
	const char* _tmp0_;
	char* old_owner = NULL;
	const char* _tmp1_;
	char* new_owner = NULL;
	const char* _tmp2_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "sss")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	name = g_strdup (_tmp0_);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	old_owner = g_strdup (_tmp1_);
	dbus_message_iter_get_basic (&iter, &_tmp2_);
	dbus_message_iter_next (&iter);
	new_owner = g_strdup (_tmp2_);
	g_signal_emit_by_name (self, "name-owner-changed", name, old_owner, new_owner);
	_g_free0 (name);
	_g_free0 (old_owner);
	_g_free0 (new_owner);
}


DBusHandlerResult free_desktop_dbus_object_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.freedesktop.DBus", "NameOwnerChanged")) {
			_dbus_handle_free_desktop_dbus_object_name_owner_changed (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void free_desktop_dbus_object_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((FreeDesktopDBusObjectDBusProxy*) self)->disposed) {
		return;
	}
	((FreeDesktopDBusObjectDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), free_desktop_dbus_object_dbus_proxy_filter, self);
	G_OBJECT_CLASS (free_desktop_dbus_object_dbus_proxy_parent_class)->dispose (self);
}


static void free_desktop_dbus_object_dbus_proxy_class_init (FreeDesktopDBusObjectDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = free_desktop_dbus_object_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = free_desktop_dbus_object_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = free_desktop_dbus_object_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = free_desktop_dbus_object_dbus_proxy_set_property;
}


static void free_desktop_dbus_object_dbus_proxy_init (FreeDesktopDBusObjectDBusProxy* self) {
}


static void free_desktop_dbus_object_dbus_proxy_list_names_async (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	FreeDesktopDBusObjectDBusProxyListNamesData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus", "ListNames");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, -1);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (FreeDesktopDBusObjectDBusProxyListNamesData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, free_desktop_dbus_object_dbus_proxy_list_names_ready, _data_, NULL);
}


static void free_desktop_dbus_object_dbus_proxy_list_names_ready (DBusPendingCall* pending, void* user_data) {
	FreeDesktopDBusObjectDBusProxyListNamesData* _data_;
	GObject * _obj_;
	GSimpleAsyncResult * _res_;
	_data_ = user_data;
	_obj_ = g_object_newv (G_TYPE_OBJECT, 0, NULL);
	_res_ = g_simple_async_result_new (_obj_, _data_->_callback_, _data_->_user_data_, _data_);
	g_simple_async_result_complete (_res_);
	g_object_unref (_obj_);
	g_object_unref (_res_);
	g_slice_free (FreeDesktopDBusObjectDBusProxyListNamesData, _data_);
	dbus_pending_call_unref (pending);
}


static char** free_desktop_dbus_object_dbus_proxy_list_names_finish (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	FreeDesktopDBusObjectDBusProxyListNamesData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	char** _result;
	int _result_length1;
	char** _tmp7_;
	int _tmp7__length;
	int _tmp7__size;
	int _tmp7__length1;
	DBusMessageIter _tmp8_;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp6_;
			_edomain = DBUS_GERROR;
			_tmp6_ = _dbus_error.name + 27;
			if (strcmp (_tmp6_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp6_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp6_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp6_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp6_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp6_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp6_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp6_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp6_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp6_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp6_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp6_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp6_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp6_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp6_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp6_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp6_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp6_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp6_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp6_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp6_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp6_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp6_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp6_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp6_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp6_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp6_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp6_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp6_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp6_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp6_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp6_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp6_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "as")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "as", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp7_ = g_new (char*, 5);
	_tmp7__length = 0;
	_tmp7__size = 4;
	_tmp7__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp8_);
	for (; dbus_message_iter_get_arg_type (&_tmp8_); _tmp7__length1++) {
		const char* _tmp9_;
		if (_tmp7__size == _tmp7__length) {
			_tmp7__size = 2 * _tmp7__size;
			_tmp7_ = g_renew (char*, _tmp7_, _tmp7__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp8_, &_tmp9_);
		dbus_message_iter_next (&_tmp8_);
		_tmp7_[_tmp7__length++] = g_strdup (_tmp9_);
	}
	_result_length1 = _tmp7__length1;
	_tmp7_[_tmp7__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp7_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static void free_desktop_dbus_object_dbus_proxy_list_activatable_names_async (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	FreeDesktopDBusObjectDBusProxyListActivatableNamesData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus", "ListActivatableNames");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, -1);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (FreeDesktopDBusObjectDBusProxyListActivatableNamesData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, free_desktop_dbus_object_dbus_proxy_list_activatable_names_ready, _data_, NULL);
}


static void free_desktop_dbus_object_dbus_proxy_list_activatable_names_ready (DBusPendingCall* pending, void* user_data) {
	FreeDesktopDBusObjectDBusProxyListActivatableNamesData* _data_;
	GObject * _obj_;
	GSimpleAsyncResult * _res_;
	_data_ = user_data;
	_obj_ = g_object_newv (G_TYPE_OBJECT, 0, NULL);
	_res_ = g_simple_async_result_new (_obj_, _data_->_callback_, _data_->_user_data_, _data_);
	g_simple_async_result_complete (_res_);
	g_object_unref (_obj_);
	g_object_unref (_res_);
	g_slice_free (FreeDesktopDBusObjectDBusProxyListActivatableNamesData, _data_);
	dbus_pending_call_unref (pending);
}


static char** free_desktop_dbus_object_dbus_proxy_list_activatable_names_finish (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	FreeDesktopDBusObjectDBusProxyListActivatableNamesData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	char** _result;
	int _result_length1;
	char** _tmp14_;
	int _tmp14__length;
	int _tmp14__size;
	int _tmp14__length1;
	DBusMessageIter _tmp15_;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp13_;
			_edomain = DBUS_GERROR;
			_tmp13_ = _dbus_error.name + 27;
			if (strcmp (_tmp13_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp13_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp13_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp13_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp13_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp13_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp13_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp13_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp13_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp13_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp13_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp13_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp13_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp13_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp13_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp13_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp13_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp13_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp13_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp13_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp13_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp13_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp13_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp13_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp13_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp13_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp13_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp13_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp13_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp13_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp13_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp13_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp13_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "as")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "as", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp14_ = g_new (char*, 5);
	_tmp14__length = 0;
	_tmp14__size = 4;
	_tmp14__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp15_);
	for (; dbus_message_iter_get_arg_type (&_tmp15_); _tmp14__length1++) {
		const char* _tmp16_;
		if (_tmp14__size == _tmp14__length) {
			_tmp14__size = 2 * _tmp14__size;
			_tmp14_ = g_renew (char*, _tmp14_, _tmp14__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp15_, &_tmp16_);
		dbus_message_iter_next (&_tmp15_);
		_tmp14_[_tmp14__length++] = g_strdup (_tmp16_);
	}
	_result_length1 = _tmp14__length1;
	_tmp14_[_tmp14__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp14_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static void free_desktop_dbus_object_dbus_proxy_free_desktop_dbus_object__interface_init (FreeDesktopDBusObjectIface* iface) {
	iface->list_names = free_desktop_dbus_object_dbus_proxy_list_names_async;
	iface->list_names_finish = free_desktop_dbus_object_dbus_proxy_list_names_finish;
	iface->list_activatable_names = free_desktop_dbus_object_dbus_proxy_list_activatable_names_async;
	iface->list_activatable_names_finish = free_desktop_dbus_object_dbus_proxy_list_activatable_names_finish;
}


static void free_desktop_dbus_object_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void free_desktop_dbus_object_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


#line 26 "rygel-volume.vala"
void free_desktop_properties_get_all (FreeDesktopProperties* self, const char* iface, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 26 "rygel-volume.vala"
	FREE_DESKTOP_PROPERTIES_GET_INTERFACE (self)->get_all (self, iface, _callback_, _user_data_);
#line 1121 "rygel-free-desktop-interfaces.c"
}


#line 26 "rygel-volume.vala"
GHashTable* free_desktop_properties_get_all_finish (FreeDesktopProperties* self, GAsyncResult* _res_, GError** error) {
#line 26 "rygel-volume.vala"
	return FREE_DESKTOP_PROPERTIES_GET_INTERFACE (self)->get_all_finish (self, _res_, error);
#line 1129 "rygel-free-desktop-interfaces.c"
}


void _free_desktop_properties_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_free_desktop_properties_introspect (FreeDesktopProperties* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"GetAll\">\n    <arg name=\"iface\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"a{sv}\" direction=\"out\"/>\n  </method>\n  <signal name=\"PropertiesChanged\">\n    <arg name=\"iface\" type=\"s\"/>\n    <arg name=\"changed\" type=\"a{sv}\"/>\n    <arg name=\"invalidated\" type=\"as\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_free_desktop_properties_property_get_all (FreeDesktopProperties* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "org.freedesktop.DBus.Properties") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_free_desktop_properties_get_all (FreeDesktopProperties* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* iface = NULL;
	const char* _tmp1_;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	iface = g_strdup (_tmp1_);
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	free_desktop_properties_get_all (self, iface, (GAsyncReadyCallback) _dbus_free_desktop_properties_get_all_ready, _user_data_);
	_g_free0 (iface);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_free_desktop_properties_get_all_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	GHashTable* result;
	DBusMessage* reply;
	DBusMessageIter _tmp2_, _tmp3_;
	GHashTableIter _tmp4_;
	gpointer _tmp5_, _tmp6_;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	result = free_desktop_properties_get_all_finish ((FreeDesktopProperties*) source_object, _res_, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "{sv}", &_tmp2_);
	g_hash_table_iter_init (&_tmp4_, result);
	while (g_hash_table_iter_next (&_tmp4_, &_tmp5_, &_tmp6_)) {
		char* _key;
		GValue* _value;
		const char* _tmp7_;
		DBusMessageIter _tmp8_;
		dbus_message_iter_open_container (&_tmp2_, DBUS_TYPE_DICT_ENTRY, NULL, &_tmp3_);
		_key = (char*) _tmp5_;
		_value = (GValue*) _tmp6_;
		_tmp7_ = _key;
		dbus_message_iter_append_basic (&_tmp3_, DBUS_TYPE_STRING, &_tmp7_);
		if (G_VALUE_TYPE (_value) == G_TYPE_UCHAR) {
			guint8 _tmp9_;
			dbus_message_iter_open_container (&_tmp3_, DBUS_TYPE_VARIANT, "y", &_tmp8_);
			_tmp9_ = g_value_get_uchar (_value);
			dbus_message_iter_append_basic (&_tmp8_, DBUS_TYPE_BYTE, &_tmp9_);
			dbus_message_iter_close_container (&_tmp3_, &_tmp8_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_BOOLEAN) {
			dbus_bool_t _tmp10_;
			dbus_message_iter_open_container (&_tmp3_, DBUS_TYPE_VARIANT, "b", &_tmp8_);
			_tmp10_ = g_value_get_boolean (_value);
			dbus_message_iter_append_basic (&_tmp8_, DBUS_TYPE_BOOLEAN, &_tmp10_);
			dbus_message_iter_close_container (&_tmp3_, &_tmp8_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_INT) {
			dbus_int32_t _tmp11_;
			dbus_message_iter_open_container (&_tmp3_, DBUS_TYPE_VARIANT, "i", &_tmp8_);
			_tmp11_ = g_value_get_int (_value);
			dbus_message_iter_append_basic (&_tmp8_, DBUS_TYPE_INT32, &_tmp11_);
			dbus_message_iter_close_container (&_tmp3_, &_tmp8_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_UINT) {
			dbus_uint32_t _tmp12_;
			dbus_message_iter_open_container (&_tmp3_, DBUS_TYPE_VARIANT, "u", &_tmp8_);
			_tmp12_ = g_value_get_uint (_value);
			dbus_message_iter_append_basic (&_tmp8_, DBUS_TYPE_UINT32, &_tmp12_);
			dbus_message_iter_close_container (&_tmp3_, &_tmp8_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_INT64) {
			dbus_int64_t _tmp13_;
			dbus_message_iter_open_container (&_tmp3_, DBUS_TYPE_VARIANT, "x", &_tmp8_);
			_tmp13_ = g_value_get_int64 (_value);
			dbus_message_iter_append_basic (&_tmp8_, DBUS_TYPE_INT64, &_tmp13_);
			dbus_message_iter_close_container (&_tmp3_, &_tmp8_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_UINT64) {
			dbus_uint64_t _tmp14_;
			dbus_message_iter_open_container (&_tmp3_, DBUS_TYPE_VARIANT, "t", &_tmp8_);
			_tmp14_ = g_value_get_uint64 (_value);
			dbus_message_iter_append_basic (&_tmp8_, DBUS_TYPE_UINT64, &_tmp14_);
			dbus_message_iter_close_container (&_tmp3_, &_tmp8_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_DOUBLE) {
			double _tmp15_;
			dbus_message_iter_open_container (&_tmp3_, DBUS_TYPE_VARIANT, "d", &_tmp8_);
			_tmp15_ = g_value_get_double (_value);
			dbus_message_iter_append_basic (&_tmp8_, DBUS_TYPE_DOUBLE, &_tmp15_);
			dbus_message_iter_close_container (&_tmp3_, &_tmp8_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_STRING) {
			const char* _tmp16_;
			dbus_message_iter_open_container (&_tmp3_, DBUS_TYPE_VARIANT, "s", &_tmp8_);
			_tmp16_ = g_value_get_string (_value);
			dbus_message_iter_append_basic (&_tmp8_, DBUS_TYPE_STRING, &_tmp16_);
			dbus_message_iter_close_container (&_tmp3_, &_tmp8_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_STRV) {
			const char** _tmp17_;
			DBusMessageIter _tmp18_;
			int _tmp19_;
			dbus_message_iter_open_container (&_tmp3_, DBUS_TYPE_VARIANT, "as", &_tmp8_);
			_tmp17_ = g_value_get_boxed (_value);
			dbus_message_iter_open_container (&_tmp8_, DBUS_TYPE_ARRAY, "s", &_tmp18_);
			for (_tmp19_ = 0; _tmp19_ < g_strv_length (g_value_get_boxed (_value)); _tmp19_++) {
				const char* _tmp20_;
				_tmp20_ = *_tmp17_;
				dbus_message_iter_append_basic (&_tmp18_, DBUS_TYPE_STRING, &_tmp20_);
				_tmp17_++;
			}
			dbus_message_iter_close_container (&_tmp8_, &_tmp18_);
			dbus_message_iter_close_container (&_tmp3_, &_tmp8_);
		}
		dbus_message_iter_close_container (&_tmp2_, &_tmp3_);
	}
	dbus_message_iter_close_container (&iter, &_tmp2_);
	_g_hash_table_unref0 (result);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


DBusHandlerResult free_desktop_properties_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_free_desktop_properties_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_free_desktop_properties_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_free_desktop_properties_get_all (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_free_desktop_properties_properties_changed (GObject* _sender, const char* iface, GHashTable* changed, char** invalidated, int invalidated_length1, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	const char* _tmp21_;
	DBusMessageIter _tmp22_, _tmp23_;
	GHashTableIter _tmp24_;
	gpointer _tmp25_, _tmp26_;
	char** _tmp41_;
	DBusMessageIter _tmp42_;
	int _tmp43_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.freedesktop.DBus.Properties", "PropertiesChanged");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp21_ = iface;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp21_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "{sv}", &_tmp22_);
	g_hash_table_iter_init (&_tmp24_, changed);
	while (g_hash_table_iter_next (&_tmp24_, &_tmp25_, &_tmp26_)) {
		char* _key;
		GValue* _value;
		const char* _tmp27_;
		DBusMessageIter _tmp28_;
		dbus_message_iter_open_container (&_tmp22_, DBUS_TYPE_DICT_ENTRY, NULL, &_tmp23_);
		_key = (char*) _tmp25_;
		_value = (GValue*) _tmp26_;
		_tmp27_ = _key;
		dbus_message_iter_append_basic (&_tmp23_, DBUS_TYPE_STRING, &_tmp27_);
		if (G_VALUE_TYPE (_value) == G_TYPE_UCHAR) {
			guint8 _tmp29_;
			dbus_message_iter_open_container (&_tmp23_, DBUS_TYPE_VARIANT, "y", &_tmp28_);
			_tmp29_ = g_value_get_uchar (_value);
			dbus_message_iter_append_basic (&_tmp28_, DBUS_TYPE_BYTE, &_tmp29_);
			dbus_message_iter_close_container (&_tmp23_, &_tmp28_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_BOOLEAN) {
			dbus_bool_t _tmp30_;
			dbus_message_iter_open_container (&_tmp23_, DBUS_TYPE_VARIANT, "b", &_tmp28_);
			_tmp30_ = g_value_get_boolean (_value);
			dbus_message_iter_append_basic (&_tmp28_, DBUS_TYPE_BOOLEAN, &_tmp30_);
			dbus_message_iter_close_container (&_tmp23_, &_tmp28_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_INT) {
			dbus_int32_t _tmp31_;
			dbus_message_iter_open_container (&_tmp23_, DBUS_TYPE_VARIANT, "i", &_tmp28_);
			_tmp31_ = g_value_get_int (_value);
			dbus_message_iter_append_basic (&_tmp28_, DBUS_TYPE_INT32, &_tmp31_);
			dbus_message_iter_close_container (&_tmp23_, &_tmp28_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_UINT) {
			dbus_uint32_t _tmp32_;
			dbus_message_iter_open_container (&_tmp23_, DBUS_TYPE_VARIANT, "u", &_tmp28_);
			_tmp32_ = g_value_get_uint (_value);
			dbus_message_iter_append_basic (&_tmp28_, DBUS_TYPE_UINT32, &_tmp32_);
			dbus_message_iter_close_container (&_tmp23_, &_tmp28_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_INT64) {
			dbus_int64_t _tmp33_;
			dbus_message_iter_open_container (&_tmp23_, DBUS_TYPE_VARIANT, "x", &_tmp28_);
			_tmp33_ = g_value_get_int64 (_value);
			dbus_message_iter_append_basic (&_tmp28_, DBUS_TYPE_INT64, &_tmp33_);
			dbus_message_iter_close_container (&_tmp23_, &_tmp28_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_UINT64) {
			dbus_uint64_t _tmp34_;
			dbus_message_iter_open_container (&_tmp23_, DBUS_TYPE_VARIANT, "t", &_tmp28_);
			_tmp34_ = g_value_get_uint64 (_value);
			dbus_message_iter_append_basic (&_tmp28_, DBUS_TYPE_UINT64, &_tmp34_);
			dbus_message_iter_close_container (&_tmp23_, &_tmp28_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_DOUBLE) {
			double _tmp35_;
			dbus_message_iter_open_container (&_tmp23_, DBUS_TYPE_VARIANT, "d", &_tmp28_);
			_tmp35_ = g_value_get_double (_value);
			dbus_message_iter_append_basic (&_tmp28_, DBUS_TYPE_DOUBLE, &_tmp35_);
			dbus_message_iter_close_container (&_tmp23_, &_tmp28_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_STRING) {
			const char* _tmp36_;
			dbus_message_iter_open_container (&_tmp23_, DBUS_TYPE_VARIANT, "s", &_tmp28_);
			_tmp36_ = g_value_get_string (_value);
			dbus_message_iter_append_basic (&_tmp28_, DBUS_TYPE_STRING, &_tmp36_);
			dbus_message_iter_close_container (&_tmp23_, &_tmp28_);
		} else if (G_VALUE_TYPE (_value) == G_TYPE_STRV) {
			const char** _tmp37_;
			DBusMessageIter _tmp38_;
			int _tmp39_;
			dbus_message_iter_open_container (&_tmp23_, DBUS_TYPE_VARIANT, "as", &_tmp28_);
			_tmp37_ = g_value_get_boxed (_value);
			dbus_message_iter_open_container (&_tmp28_, DBUS_TYPE_ARRAY, "s", &_tmp38_);
			for (_tmp39_ = 0; _tmp39_ < g_strv_length (g_value_get_boxed (_value)); _tmp39_++) {
				const char* _tmp40_;
				_tmp40_ = *_tmp37_;
				dbus_message_iter_append_basic (&_tmp38_, DBUS_TYPE_STRING, &_tmp40_);
				_tmp37_++;
			}
			dbus_message_iter_close_container (&_tmp28_, &_tmp38_);
			dbus_message_iter_close_container (&_tmp23_, &_tmp28_);
		}
		dbus_message_iter_close_container (&_tmp22_, &_tmp23_);
	}
	dbus_message_iter_close_container (&_iter, &_tmp22_);
	_tmp41_ = invalidated;
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "s", &_tmp42_);
	for (_tmp43_ = 0; _tmp43_ < invalidated_length1; _tmp43_++) {
		const char* _tmp44_;
		_tmp44_ = *_tmp41_;
		dbus_message_iter_append_basic (&_tmp42_, DBUS_TYPE_STRING, &_tmp44_);
		_tmp41_++;
	}
	dbus_message_iter_close_container (&_iter, &_tmp42_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void free_desktop_properties_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_free_desktop_properties_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "properties-changed", (GCallback) _dbus_free_desktop_properties_properties_changed, connection);
}


static void free_desktop_properties_base_init (FreeDesktopPropertiesIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("properties_changed", FREE_DESKTOP_TYPE_PROPERTIES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOXED_BOXED_INT, G_TYPE_NONE, 4, G_TYPE_STRING, G_TYPE_HASH_TABLE, G_TYPE_STRV, G_TYPE_INT);
		g_type_set_qdata (FREE_DESKTOP_TYPE_PROPERTIES, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_free_desktop_properties_dbus_vtable));
	}
}


GType free_desktop_properties_get_type (void) {
	static volatile gsize free_desktop_properties_type_id__volatile = 0;
	if (g_once_init_enter (&free_desktop_properties_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FreeDesktopPropertiesIface), (GBaseInitFunc) free_desktop_properties_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType free_desktop_properties_type_id;
		free_desktop_properties_type_id = g_type_register_static (G_TYPE_INTERFACE, "FreeDesktopProperties", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (free_desktop_properties_type_id, DBUS_TYPE_G_PROXY);
		g_type_set_qdata (free_desktop_properties_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &free_desktop_properties_dbus_proxy_get_type);
		g_once_init_leave (&free_desktop_properties_type_id__volatile, free_desktop_properties_type_id);
	}
	return free_desktop_properties_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (FreeDesktopPropertiesDBusProxy, free_desktop_properties_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (FREE_DESKTOP_TYPE_PROPERTIES, free_desktop_properties_dbus_proxy_free_desktop_properties__interface_init) );
FreeDesktopProperties* free_desktop_properties_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	FreeDesktopProperties* self;
	self = g_object_new (free_desktop_properties_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.DBus.Properties", NULL);
	return self;
}


static GObject* free_desktop_properties_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (free_desktop_properties_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), free_desktop_properties_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_free_desktop_properties_properties_changed (FreeDesktopProperties* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* iface = NULL;
	const char* _tmp17_;
	GHashTable* changed = NULL;
	GHashTable* _tmp18_;
	DBusMessageIter _tmp19_;
	DBusMessageIter _tmp20_;
	char** invalidated = NULL;
	int invalidated_length1;
	char** _tmp39_;
	int _tmp39__length;
	int _tmp39__size;
	int _tmp39__length1;
	DBusMessageIter _tmp40_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "sa{sv}as")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp17_);
	dbus_message_iter_next (&iter);
	iface = g_strdup (_tmp17_);
	_tmp18_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	dbus_message_iter_recurse (&iter, &_tmp19_);
	while (dbus_message_iter_get_arg_type (&_tmp19_)) {
		char* _key;
		GValue* _value;
		const char* _tmp21_;
		GValue _tmp22_ = {0};
		DBusMessageIter _tmp23_;
		dbus_message_iter_recurse (&_tmp19_, &_tmp20_);
		dbus_message_iter_get_basic (&_tmp20_, &_tmp21_);
		dbus_message_iter_next (&_tmp20_);
		_key = g_strdup (_tmp21_);
		dbus_message_iter_recurse (&_tmp20_, &_tmp23_);
		if (dbus_message_iter_get_arg_type (&_tmp23_) == DBUS_TYPE_BYTE) {
			guint8 _tmp24_;
			dbus_message_iter_get_basic (&_tmp23_, &_tmp24_);
			g_value_init (&_tmp22_, G_TYPE_UCHAR);
			g_value_set_uchar (&_tmp22_, _tmp24_);
		} else if (dbus_message_iter_get_arg_type (&_tmp23_) == DBUS_TYPE_BOOLEAN) {
			dbus_bool_t _tmp25_;
			dbus_message_iter_get_basic (&_tmp23_, &_tmp25_);
			g_value_init (&_tmp22_, G_TYPE_BOOLEAN);
			g_value_set_boolean (&_tmp22_, _tmp25_);
		} else if (dbus_message_iter_get_arg_type (&_tmp23_) == DBUS_TYPE_INT16) {
			dbus_int16_t _tmp26_;
			dbus_message_iter_get_basic (&_tmp23_, &_tmp26_);
			g_value_init (&_tmp22_, G_TYPE_INT);
			g_value_set_int (&_tmp22_, _tmp26_);
		} else if (dbus_message_iter_get_arg_type (&_tmp23_) == DBUS_TYPE_UINT16) {
			dbus_uint16_t _tmp27_;
			dbus_message_iter_get_basic (&_tmp23_, &_tmp27_);
			g_value_init (&_tmp22_, G_TYPE_UINT);
			g_value_set_uint (&_tmp22_, _tmp27_);
		} else if (dbus_message_iter_get_arg_type (&_tmp23_) == DBUS_TYPE_INT32) {
			dbus_int32_t _tmp28_;
			dbus_message_iter_get_basic (&_tmp23_, &_tmp28_);
			g_value_init (&_tmp22_, G_TYPE_INT);
			g_value_set_int (&_tmp22_, _tmp28_);
		} else if (dbus_message_iter_get_arg_type (&_tmp23_) == DBUS_TYPE_UINT32) {
			dbus_uint32_t _tmp29_;
			dbus_message_iter_get_basic (&_tmp23_, &_tmp29_);
			g_value_init (&_tmp22_, G_TYPE_UINT);
			g_value_set_uint (&_tmp22_, _tmp29_);
		} else if (dbus_message_iter_get_arg_type (&_tmp23_) == DBUS_TYPE_INT64) {
			dbus_int64_t _tmp30_;
			dbus_message_iter_get_basic (&_tmp23_, &_tmp30_);
			g_value_init (&_tmp22_, G_TYPE_INT64);
			g_value_set_int64 (&_tmp22_, _tmp30_);
		} else if (dbus_message_iter_get_arg_type (&_tmp23_) == DBUS_TYPE_UINT64) {
			dbus_uint64_t _tmp31_;
			dbus_message_iter_get_basic (&_tmp23_, &_tmp31_);
			g_value_init (&_tmp22_, G_TYPE_UINT64);
			g_value_set_uint64 (&_tmp22_, _tmp31_);
		} else if (dbus_message_iter_get_arg_type (&_tmp23_) == DBUS_TYPE_DOUBLE) {
			double _tmp32_;
			dbus_message_iter_get_basic (&_tmp23_, &_tmp32_);
			g_value_init (&_tmp22_, G_TYPE_DOUBLE);
			g_value_set_double (&_tmp22_, _tmp32_);
		} else if (dbus_message_iter_get_arg_type (&_tmp23_) == DBUS_TYPE_STRING) {
			const char* _tmp33_;
			dbus_message_iter_get_basic (&_tmp23_, &_tmp33_);
			g_value_init (&_tmp22_, G_TYPE_STRING);
			g_value_take_string (&_tmp22_, g_strdup (_tmp33_));
		} else if (dbus_message_iter_get_arg_type (&_tmp23_) == DBUS_TYPE_OBJECT_PATH) {
			const char* _tmp34_;
			dbus_message_iter_get_basic (&_tmp23_, &_tmp34_);
			g_value_init (&_tmp22_, G_TYPE_STRING);
			g_value_take_string (&_tmp22_, g_strdup (_tmp34_));
		} else if (dbus_message_iter_get_arg_type (&_tmp23_) == DBUS_TYPE_SIGNATURE) {
			const char* _tmp35_;
			dbus_message_iter_get_basic (&_tmp23_, &_tmp35_);
			g_value_init (&_tmp22_, G_TYPE_STRING);
			g_value_take_string (&_tmp22_, g_strdup (_tmp35_));
		} else if ((dbus_message_iter_get_arg_type (&_tmp23_) == DBUS_TYPE_ARRAY) && (dbus_message_iter_get_element_type (&_tmp23_) == DBUS_TYPE_STRING)) {
			const char** _tmp36_;
			int _tmp36__length;
			int _tmp36__size;
			int _tmp36__length1;
			DBusMessageIter _tmp37_;
			_tmp36_ = g_new (const char*, 5);
			_tmp36__length = 0;
			_tmp36__size = 4;
			_tmp36__length1 = 0;
			dbus_message_iter_recurse (&_tmp23_, &_tmp37_);
			for (; dbus_message_iter_get_arg_type (&_tmp37_); _tmp36__length1++) {
				const char* _tmp38_;
				if (_tmp36__size == _tmp36__length) {
					_tmp36__size = 2 * _tmp36__size;
					_tmp36_ = g_renew (const char*, _tmp36_, _tmp36__size + 1);
				}
				dbus_message_iter_get_basic (&_tmp37_, &_tmp38_);
				dbus_message_iter_next (&_tmp37_);
				_tmp36_[_tmp36__length++] = g_strdup (_tmp38_);
			}
			_tmp36_[_tmp36__length] = NULL;
			g_value_init (&_tmp22_, G_TYPE_STRV);
			g_value_take_boxed (&_tmp22_, _tmp36_);
		}
		dbus_message_iter_next (&_tmp20_);
		_value = g_memdup (&_tmp22_, sizeof (GValue));
		g_hash_table_insert (_tmp18_, _key, _value);
		dbus_message_iter_next (&_tmp19_);
	}
	dbus_message_iter_next (&iter);
	changed = _tmp18_;
	invalidated_length1 = 0;
	_tmp39_ = g_new (char*, 5);
	_tmp39__length = 0;
	_tmp39__size = 4;
	_tmp39__length1 = 0;
	dbus_message_iter_recurse (&iter, &_tmp40_);
	for (; dbus_message_iter_get_arg_type (&_tmp40_); _tmp39__length1++) {
		const char* _tmp41_;
		if (_tmp39__size == _tmp39__length) {
			_tmp39__size = 2 * _tmp39__size;
			_tmp39_ = g_renew (char*, _tmp39_, _tmp39__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp40_, &_tmp41_);
		dbus_message_iter_next (&_tmp40_);
		_tmp39_[_tmp39__length++] = g_strdup (_tmp41_);
	}
	invalidated_length1 = _tmp39__length1;
	_tmp39_[_tmp39__length] = NULL;
	dbus_message_iter_next (&iter);
	invalidated = _tmp39_;
	g_signal_emit_by_name (self, "properties-changed", iface, changed, invalidated, invalidated_length1);
	_g_free0 (iface);
	_g_hash_table_unref0 (changed);
	invalidated = (_vala_array_free (invalidated, invalidated_length1, (GDestroyNotify) g_free), NULL);
}


DBusHandlerResult free_desktop_properties_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.freedesktop.DBus.Properties", "PropertiesChanged")) {
			_dbus_handle_free_desktop_properties_properties_changed (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void free_desktop_properties_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((FreeDesktopPropertiesDBusProxy*) self)->disposed) {
		return;
	}
	((FreeDesktopPropertiesDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), free_desktop_properties_dbus_proxy_filter, self);
	G_OBJECT_CLASS (free_desktop_properties_dbus_proxy_parent_class)->dispose (self);
}


static void free_desktop_properties_dbus_proxy_class_init (FreeDesktopPropertiesDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = free_desktop_properties_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = free_desktop_properties_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = free_desktop_properties_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = free_desktop_properties_dbus_proxy_set_property;
}


static void free_desktop_properties_dbus_proxy_init (FreeDesktopPropertiesDBusProxy* self) {
}


static void free_desktop_properties_dbus_proxy_get_all_async (FreeDesktopProperties* self, const char* iface, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	const char* _tmp42_;
	FreeDesktopPropertiesDBusProxyGetAllData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "GetAll");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp42_ = iface;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp42_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, -1);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (FreeDesktopPropertiesDBusProxyGetAllData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, free_desktop_properties_dbus_proxy_get_all_ready, _data_, NULL);
}


static void free_desktop_properties_dbus_proxy_get_all_ready (DBusPendingCall* pending, void* user_data) {
	FreeDesktopPropertiesDBusProxyGetAllData* _data_;
	GObject * _obj_;
	GSimpleAsyncResult * _res_;
	_data_ = user_data;
	_obj_ = g_object_newv (G_TYPE_OBJECT, 0, NULL);
	_res_ = g_simple_async_result_new (_obj_, _data_->_callback_, _data_->_user_data_, _data_);
	g_simple_async_result_complete (_res_);
	g_object_unref (_obj_);
	g_object_unref (_res_);
	g_slice_free (FreeDesktopPropertiesDBusProxyGetAllData, _data_);
	dbus_pending_call_unref (pending);
}


static GHashTable* free_desktop_properties_dbus_proxy_get_all_finish (FreeDesktopProperties* self, GAsyncResult* _res_, GError** error) {
	FreeDesktopPropertiesDBusProxyGetAllData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	GHashTable* _result;
	GHashTable* _tmp66_;
	DBusMessageIter _tmp67_;
	DBusMessageIter _tmp68_;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp64_;
			_edomain = DBUS_GERROR;
			_tmp64_ = _dbus_error.name + 27;
			if (strcmp (_tmp64_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp64_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp64_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp64_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp64_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp64_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp64_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp64_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp64_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp64_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp64_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp64_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp64_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp64_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp64_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp64_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp64_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp64_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp64_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp64_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp64_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp64_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp64_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp64_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp64_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp64_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp64_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp64_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp64_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp64_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp64_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp64_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp64_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "a{sv}")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "a{sv}", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_tmp66_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	dbus_message_iter_recurse (&_iter, &_tmp67_);
	while (dbus_message_iter_get_arg_type (&_tmp67_)) {
		char* _key;
		GValue* _value;
		const char* _tmp69_;
		GValue _tmp70_ = {0};
		DBusMessageIter _tmp71_;
		dbus_message_iter_recurse (&_tmp67_, &_tmp68_);
		dbus_message_iter_get_basic (&_tmp68_, &_tmp69_);
		dbus_message_iter_next (&_tmp68_);
		_key = g_strdup (_tmp69_);
		dbus_message_iter_recurse (&_tmp68_, &_tmp71_);
		if (dbus_message_iter_get_arg_type (&_tmp71_) == DBUS_TYPE_BYTE) {
			guint8 _tmp72_;
			dbus_message_iter_get_basic (&_tmp71_, &_tmp72_);
			g_value_init (&_tmp70_, G_TYPE_UCHAR);
			g_value_set_uchar (&_tmp70_, _tmp72_);
		} else if (dbus_message_iter_get_arg_type (&_tmp71_) == DBUS_TYPE_BOOLEAN) {
			dbus_bool_t _tmp73_;
			dbus_message_iter_get_basic (&_tmp71_, &_tmp73_);
			g_value_init (&_tmp70_, G_TYPE_BOOLEAN);
			g_value_set_boolean (&_tmp70_, _tmp73_);
		} else if (dbus_message_iter_get_arg_type (&_tmp71_) == DBUS_TYPE_INT16) {
			dbus_int16_t _tmp74_;
			dbus_message_iter_get_basic (&_tmp71_, &_tmp74_);
			g_value_init (&_tmp70_, G_TYPE_INT);
			g_value_set_int (&_tmp70_, _tmp74_);
		} else if (dbus_message_iter_get_arg_type (&_tmp71_) == DBUS_TYPE_UINT16) {
			dbus_uint16_t _tmp75_;
			dbus_message_iter_get_basic (&_tmp71_, &_tmp75_);
			g_value_init (&_tmp70_, G_TYPE_UINT);
			g_value_set_uint (&_tmp70_, _tmp75_);
		} else if (dbus_message_iter_get_arg_type (&_tmp71_) == DBUS_TYPE_INT32) {
			dbus_int32_t _tmp76_;
			dbus_message_iter_get_basic (&_tmp71_, &_tmp76_);
			g_value_init (&_tmp70_, G_TYPE_INT);
			g_value_set_int (&_tmp70_, _tmp76_);
		} else if (dbus_message_iter_get_arg_type (&_tmp71_) == DBUS_TYPE_UINT32) {
			dbus_uint32_t _tmp77_;
			dbus_message_iter_get_basic (&_tmp71_, &_tmp77_);
			g_value_init (&_tmp70_, G_TYPE_UINT);
			g_value_set_uint (&_tmp70_, _tmp77_);
		} else if (dbus_message_iter_get_arg_type (&_tmp71_) == DBUS_TYPE_INT64) {
			dbus_int64_t _tmp78_;
			dbus_message_iter_get_basic (&_tmp71_, &_tmp78_);
			g_value_init (&_tmp70_, G_TYPE_INT64);
			g_value_set_int64 (&_tmp70_, _tmp78_);
		} else if (dbus_message_iter_get_arg_type (&_tmp71_) == DBUS_TYPE_UINT64) {
			dbus_uint64_t _tmp79_;
			dbus_message_iter_get_basic (&_tmp71_, &_tmp79_);
			g_value_init (&_tmp70_, G_TYPE_UINT64);
			g_value_set_uint64 (&_tmp70_, _tmp79_);
		} else if (dbus_message_iter_get_arg_type (&_tmp71_) == DBUS_TYPE_DOUBLE) {
			double _tmp80_;
			dbus_message_iter_get_basic (&_tmp71_, &_tmp80_);
			g_value_init (&_tmp70_, G_TYPE_DOUBLE);
			g_value_set_double (&_tmp70_, _tmp80_);
		} else if (dbus_message_iter_get_arg_type (&_tmp71_) == DBUS_TYPE_STRING) {
			const char* _tmp81_;
			dbus_message_iter_get_basic (&_tmp71_, &_tmp81_);
			g_value_init (&_tmp70_, G_TYPE_STRING);
			g_value_take_string (&_tmp70_, g_strdup (_tmp81_));
		} else if (dbus_message_iter_get_arg_type (&_tmp71_) == DBUS_TYPE_OBJECT_PATH) {
			const char* _tmp82_;
			dbus_message_iter_get_basic (&_tmp71_, &_tmp82_);
			g_value_init (&_tmp70_, G_TYPE_STRING);
			g_value_take_string (&_tmp70_, g_strdup (_tmp82_));
		} else if (dbus_message_iter_get_arg_type (&_tmp71_) == DBUS_TYPE_SIGNATURE) {
			const char* _tmp83_;
			dbus_message_iter_get_basic (&_tmp71_, &_tmp83_);
			g_value_init (&_tmp70_, G_TYPE_STRING);
			g_value_take_string (&_tmp70_, g_strdup (_tmp83_));
		} else if ((dbus_message_iter_get_arg_type (&_tmp71_) == DBUS_TYPE_ARRAY) && (dbus_message_iter_get_element_type (&_tmp71_) == DBUS_TYPE_STRING)) {
			const char** _tmp84_;
			int _tmp84__length;
			int _tmp84__size;
			int _tmp84__length1;
			DBusMessageIter _tmp85_;
			_tmp84_ = g_new (const char*, 5);
			_tmp84__length = 0;
			_tmp84__size = 4;
			_tmp84__length1 = 0;
			dbus_message_iter_recurse (&_tmp71_, &_tmp85_);
			for (; dbus_message_iter_get_arg_type (&_tmp85_); _tmp84__length1++) {
				const char* _tmp86_;
				if (_tmp84__size == _tmp84__length) {
					_tmp84__size = 2 * _tmp84__size;
					_tmp84_ = g_renew (const char*, _tmp84_, _tmp84__size + 1);
				}
				dbus_message_iter_get_basic (&_tmp85_, &_tmp86_);
				dbus_message_iter_next (&_tmp85_);
				_tmp84_[_tmp84__length++] = g_strdup (_tmp86_);
			}
			_tmp84_[_tmp84__length] = NULL;
			g_value_init (&_tmp70_, G_TYPE_STRV);
			g_value_take_boxed (&_tmp70_, _tmp84_);
		}
		dbus_message_iter_next (&_tmp68_);
		_value = g_memdup (&_tmp70_, sizeof (GValue));
		g_hash_table_insert (_tmp66_, _key, _value);
		dbus_message_iter_next (&_tmp67_);
	}
	dbus_message_iter_next (&_iter);
	_result = _tmp66_;
	dbus_message_unref (_reply);
	return _result;
}


static void free_desktop_properties_dbus_proxy_free_desktop_properties__interface_init (FreeDesktopPropertiesIface* iface) {
	iface->get_all = free_desktop_properties_dbus_proxy_get_all_async;
	iface->get_all_finish = free_desktop_properties_dbus_proxy_get_all_finish;
}


static void free_desktop_properties_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void free_desktop_properties_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), data2);
}


static void g_cclosure_user_marshal_VOID__STRING_BOXED_BOXED_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_BOXED_BOXED_INT) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOXED_BOXED_INT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_BOXED_BOXED_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boxed (param_values + 2), g_value_get_boxed (param_values + 3), g_value_get_int (param_values + 4), data2);
}



