/* valaconstant.c generated by valac, the Vala compiler
 * generated from valaconstant.vala, do not modify */

/* valaconstant.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaConstantPrivate {
	ValaDataType* _data_type;
	ValaExpression* _value;
};

static gint ValaConstant_private_offset;
static gpointer vala_constant_parent_class = NULL;

static void vala_constant_set_type_reference (ValaConstant* self,
                                       ValaDataType* value);
static void vala_constant_set_value (ValaConstant* self,
                              ValaExpression* value);
static void vala_constant_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor);
static void vala_constant_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static void vala_constant_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node);
static void vala_constant_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type);
static gboolean vala_constant_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context);
static gboolean vala_constant_check_const_type (ValaConstant* self,
                                         ValaDataType* type,
                                         ValaCodeContext* context);
static void vala_constant_finalize (ValaCodeNode * obj);
static GType vala_constant_get_type_once (void);

static inline gpointer
vala_constant_get_instance_private (ValaConstant* self)
{
	return G_STRUCT_MEMBER_P (self, ValaConstant_private_offset);
}

ValaDataType*
vala_constant_get_type_reference (ValaConstant* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_constant_set_type_reference (ValaConstant* self,
                                  ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	_tmp1_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaExpression*
vala_constant_get_value (ValaConstant* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value;
	result = _tmp0_;
	return result;
}

static void
vala_constant_set_value (ValaConstant* self,
                         ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_value);
	self->priv->_value = _tmp0_;
	_tmp1_ = self->priv->_value;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_value;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

/**
 * Creates a new constant.
 *
 * @param name             constant name
 * @param type_reference   constant type
 * @param value            constant value
 * @param source_reference reference to source code
 * @return                 newly created constant
 */
ValaConstant*
vala_constant_construct (GType object_type,
                         const gchar* name,
                         ValaDataType* type_reference,
                         ValaExpression* value,
                         ValaSourceReference* source_reference,
                         ValaComment* comment)
{
	ValaConstant* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaConstant*) vala_symbol_construct (object_type, name, source_reference, comment);
	if (type_reference != NULL) {
		vala_constant_set_type_reference (self, type_reference);
	}
	vala_constant_set_value (self, value);
	return self;
}

ValaConstant*
vala_constant_new (const gchar* name,
                   ValaDataType* type_reference,
                   ValaExpression* value,
                   ValaSourceReference* source_reference,
                   ValaComment* comment)
{
	return vala_constant_construct (VALA_TYPE_CONSTANT, name, type_reference, value, source_reference, comment);
}

static void
vala_constant_real_accept (ValaCodeNode* base,
                           ValaCodeVisitor* visitor)
{
	ValaConstant * self;
	self = (ValaConstant*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_constant (visitor, self);
}

static void
vala_constant_real_accept_children (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaConstant * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaConstant*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_constant_get_type_reference (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_constant_get_value (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_constant_get_value (self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
}

static void
vala_constant_real_replace_expression (ValaCodeNode* base,
                                       ValaExpression* old_node,
                                       ValaExpression* new_node)
{
	ValaConstant * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaConstant*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_constant_get_value (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_constant_set_value (self, new_node);
	}
}

static void
vala_constant_real_replace_type (ValaCodeNode* base,
                                 ValaDataType* old_type,
                                 ValaDataType* new_type)
{
	ValaConstant * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaConstant*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_constant_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_constant_set_type_reference (self, new_type);
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_constant_real_check (ValaCodeNode* base,
                          ValaCodeContext* context)
{
	ValaConstant * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSymbol* _tmp22_;
	ValaSymbol* _tmp23_;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp27_;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	ValaDataType* _tmp36_;
	ValaDataType* _tmp37_;
	gboolean _tmp46_;
	gboolean _tmp47_;
	gboolean _tmp124_ = FALSE;
	gboolean _tmp125_ = FALSE;
	gboolean _tmp126_;
	gboolean _tmp127_;
	ValaSemanticAnalyzer* _tmp140_;
	ValaSemanticAnalyzer* _tmp141_;
	ValaSourceFile* _tmp142_;
	ValaSemanticAnalyzer* _tmp143_;
	ValaSemanticAnalyzer* _tmp144_;
	ValaSymbol* _tmp145_;
	gboolean _tmp146_;
	gboolean _tmp147_;
	gboolean result;
	self = (ValaConstant*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp23_ = _tmp22_;
	if (!VALA_IS_BLOCK (_tmp23_)) {
		ValaSemanticAnalyzer* _tmp24_;
		ValaSemanticAnalyzer* _tmp25_;
		_tmp24_ = vala_code_context_get_analyzer (context);
		_tmp25_ = _tmp24_;
		vala_semantic_analyzer_set_current_symbol (_tmp25_, (ValaSymbol*) self);
	}
	_tmp26_ = vala_constant_get_type_reference (self);
	_tmp27_ = _tmp26_;
	vala_code_node_check ((ValaCodeNode*) _tmp27_, context);
	_tmp28_ = vala_constant_get_type_reference (self);
	_tmp29_ = _tmp28_;
	if (!vala_constant_check_const_type (self, _tmp29_, context)) {
		ValaSourceReference* _tmp30_;
		ValaSourceReference* _tmp31_;
		ValaDataType* _tmp32_;
		ValaDataType* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_constant_get_type_reference (self);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_code_node_to_string ((ValaCodeNode*) _tmp33_);
		_tmp35_ = _tmp34_;
		vala_report_error (_tmp31_, "`%s' not supported as type for constants", _tmp35_);
		_g_free0 (_tmp35_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp36_ = vala_constant_get_type_reference (self);
	_tmp37_ = _tmp36_;
	if (!vala_data_type_is_accessible (_tmp37_, (ValaSymbol*) self)) {
		ValaSourceReference* _tmp38_;
		ValaSourceReference* _tmp39_;
		ValaDataType* _tmp40_;
		ValaDataType* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp38_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_constant_get_type_reference (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_code_node_to_string ((ValaCodeNode*) _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp45_ = _tmp44_;
		vala_report_error (_tmp39_, "constant type `%s' is less accessible than constant `%s'", _tmp43_, _tmp45_);
		_g_free0 (_tmp45_);
		_g_free0 (_tmp43_);
	}
	_tmp46_ = vala_symbol_get_external ((ValaSymbol*) self);
	_tmp47_ = _tmp46_;
	if (!_tmp47_) {
		ValaExpression* _tmp48_;
		ValaExpression* _tmp49_;
		_tmp48_ = vala_constant_get_value (self);
		_tmp49_ = _tmp48_;
		if (_tmp49_ == NULL) {
			ValaSourceFileType _tmp50_;
			ValaSourceFileType _tmp51_;
			_tmp50_ = vala_symbol_get_source_type ((ValaSymbol*) self);
			_tmp51_ = _tmp50_;
			if (_tmp51_ != VALA_SOURCE_FILE_TYPE_FAST) {
				ValaSourceReference* _tmp52_;
				ValaSourceReference* _tmp53_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp52_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp53_ = _tmp52_;
				vala_report_error (_tmp53_, "A const field requires a value to be provided");
			}
		} else {
			ValaExpression* _tmp54_;
			ValaExpression* _tmp55_;
			ValaDataType* _tmp56_;
			ValaDataType* _tmp57_;
			gboolean _tmp58_ = FALSE;
			ValaExpression* _tmp59_;
			ValaExpression* _tmp60_;
			ValaExpression* _tmp65_;
			ValaExpression* _tmp66_;
			ValaDataType* _tmp67_;
			ValaDataType* _tmp68_;
			ValaDataType* _tmp69_;
			ValaDataType* _tmp70_;
			ValaMethodCall* call = NULL;
			ValaExpression* _tmp83_;
			ValaExpression* _tmp84_;
			ValaMethodCall* _tmp85_;
			ValaExpression* _tmp106_;
			ValaExpression* _tmp107_;
			ValaExpression* _tmp112_;
			ValaExpression* _tmp113_;
			_tmp54_ = vala_constant_get_value (self);
			_tmp55_ = _tmp54_;
			_tmp56_ = vala_constant_get_type_reference (self);
			_tmp57_ = _tmp56_;
			vala_expression_set_target_type (_tmp55_, _tmp57_);
			_tmp59_ = vala_constant_get_value (self);
			_tmp60_ = _tmp59_;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp60_, context)) {
				_tmp58_ = TRUE;
			} else {
				ValaDataType* _tmp61_;
				ValaDataType* _tmp62_;
				gboolean _tmp63_;
				gboolean _tmp64_;
				_tmp61_ = vala_constant_get_type_reference (self);
				_tmp62_ = _tmp61_;
				_tmp63_ = vala_code_node_get_error ((ValaCodeNode*) _tmp62_);
				_tmp64_ = _tmp63_;
				_tmp58_ = _tmp64_;
			}
			if (_tmp58_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp65_ = vala_constant_get_value (self);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_expression_get_value_type (_tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = vala_constant_get_type_reference (self);
			_tmp70_ = _tmp69_;
			if (!vala_data_type_compatible (_tmp68_, _tmp70_)) {
				ValaSourceReference* _tmp71_;
				ValaSourceReference* _tmp72_;
				ValaExpression* _tmp73_;
				ValaExpression* _tmp74_;
				ValaDataType* _tmp75_;
				ValaDataType* _tmp76_;
				gchar* _tmp77_;
				gchar* _tmp78_;
				ValaDataType* _tmp79_;
				ValaDataType* _tmp80_;
				gchar* _tmp81_;
				gchar* _tmp82_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp71_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp72_ = _tmp71_;
				_tmp73_ = vala_constant_get_value (self);
				_tmp74_ = _tmp73_;
				_tmp75_ = vala_expression_get_value_type (_tmp74_);
				_tmp76_ = _tmp75_;
				_tmp77_ = vala_code_node_to_string ((ValaCodeNode*) _tmp76_);
				_tmp78_ = _tmp77_;
				_tmp79_ = vala_constant_get_type_reference (self);
				_tmp80_ = _tmp79_;
				_tmp81_ = vala_code_node_to_string ((ValaCodeNode*) _tmp80_);
				_tmp82_ = _tmp81_;
				vala_report_error (_tmp72_, "Cannot convert from `%s' to `%s'", _tmp78_, _tmp82_);
				_g_free0 (_tmp82_);
				_g_free0 (_tmp78_);
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp83_ = vala_constant_get_value (self);
			_tmp84_ = _tmp83_;
			call = VALA_IS_METHOD_CALL (_tmp84_) ? ((ValaMethodCall*) _tmp84_) : NULL;
			_tmp85_ = call;
			if (_tmp85_ != NULL) {
				ValaMethodType* method_type = NULL;
				ValaMethodCall* _tmp86_;
				ValaExpression* _tmp87_;
				ValaExpression* _tmp88_;
				ValaDataType* _tmp89_;
				ValaDataType* _tmp90_;
				gboolean _tmp91_ = FALSE;
				ValaMethodType* _tmp92_;
				_tmp86_ = call;
				_tmp87_ = vala_method_call_get_call (_tmp86_);
				_tmp88_ = _tmp87_;
				_tmp89_ = vala_expression_get_value_type (_tmp88_);
				_tmp90_ = _tmp89_;
				method_type = VALA_IS_METHOD_TYPE (_tmp90_) ? ((ValaMethodType*) _tmp90_) : NULL;
				_tmp92_ = method_type;
				if (_tmp92_ != NULL) {
					ValaMethodType* _tmp93_;
					ValaMethod* _tmp94_;
					ValaMethod* _tmp95_;
					gchar* _tmp96_;
					gchar* _tmp97_;
					_tmp93_ = method_type;
					_tmp94_ = vala_method_type_get_method_symbol (_tmp93_);
					_tmp95_ = _tmp94_;
					_tmp96_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp95_);
					_tmp97_ = _tmp96_;
					_tmp91_ = g_strcmp0 (_tmp97_, "GLib._") == 0;
					_g_free0 (_tmp97_);
				} else {
					_tmp91_ = FALSE;
				}
				if (_tmp91_) {
					ValaStringLiteral* literal = NULL;
					ValaMethodCall* _tmp98_;
					ValaList* _tmp99_;
					gpointer _tmp100_;
					ValaExpression* _tmp101_;
					ValaStringLiteral* _tmp102_;
					ValaStringLiteral* _tmp103_;
					_tmp98_ = call;
					_tmp99_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp98_);
					_tmp100_ = vala_list_get (_tmp99_, 0);
					_tmp101_ = (ValaExpression*) _tmp100_;
					_tmp102_ = VALA_IS_STRING_LITERAL (_tmp101_) ? ((ValaStringLiteral*) _tmp101_) : NULL;
					if (_tmp102_ == NULL) {
						_vala_code_node_unref0 (_tmp101_);
					}
					literal = _tmp102_;
					_tmp103_ = literal;
					if (_tmp103_ != NULL) {
						ValaStringLiteral* _tmp104_;
						ValaStringLiteral* _tmp105_;
						_tmp104_ = literal;
						vala_constant_set_value (self, (ValaExpression*) _tmp104_);
						_tmp105_ = literal;
						vala_string_literal_set_translate (_tmp105_, TRUE);
					}
					_vala_code_node_unref0 (literal);
				}
			}
			_tmp106_ = vala_constant_get_value (self);
			_tmp107_ = _tmp106_;
			if (!vala_expression_is_constant (_tmp107_)) {
				ValaExpression* _tmp108_;
				ValaExpression* _tmp109_;
				ValaSourceReference* _tmp110_;
				ValaSourceReference* _tmp111_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp108_ = vala_constant_get_value (self);
				_tmp109_ = _tmp108_;
				_tmp110_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp109_);
				_tmp111_ = _tmp110_;
				vala_report_error (_tmp111_, "Value must be constant");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp112_ = vala_constant_get_value (self);
			_tmp113_ = _tmp112_;
			if (!vala_expression_is_accessible (_tmp113_, (ValaSymbol*) self)) {
				ValaExpression* _tmp114_;
				ValaExpression* _tmp115_;
				ValaSourceReference* _tmp116_;
				ValaSourceReference* _tmp117_;
				gchar* _tmp118_;
				gchar* _tmp119_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp114_ = vala_constant_get_value (self);
				_tmp115_ = _tmp114_;
				_tmp116_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp115_);
				_tmp117_ = _tmp116_;
				_tmp118_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp119_ = _tmp118_;
				vala_report_error (_tmp117_, "value is less accessible than constant `%s'", _tmp119_);
				_g_free0 (_tmp119_);
			}
		}
	} else {
		ValaExpression* _tmp120_;
		ValaExpression* _tmp121_;
		_tmp120_ = vala_constant_get_value (self);
		_tmp121_ = _tmp120_;
		if (_tmp121_ != NULL) {
			ValaSourceReference* _tmp122_;
			ValaSourceReference* _tmp123_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp122_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp123_ = _tmp122_;
			vala_report_error (_tmp123_, "External constants cannot use values");
		}
	}
	_tmp126_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp127_ = _tmp126_;
	if (!_tmp127_) {
		gboolean _tmp128_;
		gboolean _tmp129_;
		_tmp128_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp129_ = _tmp128_;
		_tmp125_ = !_tmp129_;
	} else {
		_tmp125_ = FALSE;
	}
	if (_tmp125_) {
		ValaSymbol* _tmp130_;
		ValaSymbol* _tmp131_;
		_tmp130_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp131_ = _tmp130_;
		_tmp124_ = _tmp131_ != NULL;
		_vala_code_node_unref0 (_tmp131_);
	} else {
		_tmp124_ = FALSE;
	}
	if (_tmp124_) {
		ValaSourceReference* _tmp132_;
		ValaSourceReference* _tmp133_;
		gchar* _tmp134_;
		gchar* _tmp135_;
		ValaSymbol* _tmp136_;
		ValaSymbol* _tmp137_;
		gchar* _tmp138_;
		gchar* _tmp139_;
		_tmp132_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp133_ = _tmp132_;
		_tmp134_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp135_ = _tmp134_;
		_tmp136_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp137_ = _tmp136_;
		_tmp138_ = vala_symbol_get_full_name (_tmp137_);
		_tmp139_ = _tmp138_;
		vala_report_warning (_tmp133_, "%s hides inherited constant `%s'. Use the `new' keyword if hiding was " \
"intentional", _tmp135_, _tmp139_);
		_g_free0 (_tmp139_);
		_vala_code_node_unref0 (_tmp137_);
		_g_free0 (_tmp135_);
	}
	_tmp140_ = vala_code_context_get_analyzer (context);
	_tmp141_ = _tmp140_;
	_tmp142_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp141_, _tmp142_);
	_tmp143_ = vala_code_context_get_analyzer (context);
	_tmp144_ = _tmp143_;
	_tmp145_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp144_, _tmp145_);
	vala_symbol_set_active ((ValaSymbol*) self, TRUE);
	_tmp146_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp147_ = _tmp146_;
	result = !_tmp147_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static gboolean
vala_constant_check_const_type (ValaConstant* self,
                                ValaDataType* type,
                                ValaCodeContext* context)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	if (VALA_IS_VALUE_TYPE (type)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp0_ = FALSE;
		if (VALA_IS_VOID_TYPE (type)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = VALA_IS_POINTER_TYPE (type);
		}
		if (_tmp0_) {
			result = FALSE;
			return result;
		} else {
			if (VALA_IS_ARRAY_TYPE (type)) {
				ValaArrayType* array_type = NULL;
				ValaArrayType* _tmp1_;
				ValaDataType* _tmp2_;
				ValaDataType* _tmp3_;
				array_type = G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
				_tmp1_ = array_type;
				_tmp2_ = vala_array_type_get_element_type (_tmp1_);
				_tmp3_ = _tmp2_;
				result = vala_constant_check_const_type (self, _tmp3_, context);
				return result;
			} else {
				ValaTypeSymbol* _tmp4_;
				ValaTypeSymbol* _tmp5_;
				_tmp4_ = vala_data_type_get_type_symbol (type);
				_tmp5_ = _tmp4_;
				if (_tmp5_ != NULL) {
					ValaTypeSymbol* _tmp6_;
					ValaTypeSymbol* _tmp7_;
					ValaSemanticAnalyzer* _tmp8_;
					ValaSemanticAnalyzer* _tmp9_;
					ValaDataType* _tmp10_;
					ValaTypeSymbol* _tmp11_;
					ValaTypeSymbol* _tmp12_;
					_tmp6_ = vala_data_type_get_type_symbol (type);
					_tmp7_ = _tmp6_;
					_tmp8_ = vala_code_context_get_analyzer (context);
					_tmp9_ = _tmp8_;
					_tmp10_ = _tmp9_->string_type;
					_tmp11_ = vala_data_type_get_type_symbol (_tmp10_);
					_tmp12_ = _tmp11_;
					result = vala_typesymbol_is_subtype_of (_tmp7_, _tmp12_);
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

static void
vala_constant_class_init (ValaConstantClass * klass,
                          gpointer klass_data)
{
	vala_constant_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_constant_finalize;
	g_type_class_adjust_private_offset (klass, &ValaConstant_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_constant_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_constant_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_constant_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_constant_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_constant_real_check;
}

static void
vala_constant_instance_init (ValaConstant * self,
                             gpointer klass)
{
	self->priv = vala_constant_get_instance_private (self);
}

static void
vala_constant_finalize (ValaCodeNode * obj)
{
	ValaConstant * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CONSTANT, ValaConstant);
	_vala_code_node_unref0 (self->priv->_data_type);
	_vala_code_node_unref0 (self->priv->_value);
	VALA_CODE_NODE_CLASS (vala_constant_parent_class)->finalize (obj);
}

/**
 * Represents a type member with a constant value.
 */
static GType
vala_constant_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaConstantClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_constant_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaConstant), 0, (GInstanceInitFunc) vala_constant_instance_init, NULL };
	GType vala_constant_type_id;
	vala_constant_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaConstant", &g_define_type_info, 0);
	ValaConstant_private_offset = g_type_add_instance_private (vala_constant_type_id, sizeof (ValaConstantPrivate));
	return vala_constant_type_id;
}

GType
vala_constant_get_type (void)
{
	static volatile gsize vala_constant_type_id__once = 0;
	if (g_once_init_enter (&vala_constant_type_id__once)) {
		GType vala_constant_type_id;
		vala_constant_type_id = vala_constant_get_type_once ();
		g_once_init_leave (&vala_constant_type_id__once, vala_constant_type_id);
	}
	return vala_constant_type_id__once;
}

