untrusted comment: verify with openbsd-74-base.pub
RWRoyQmAD08ajTJOKkFuKqbmW5sz9Ea5eDfo/4V2y6XcK3UQItvjmw2W6SR3j4zdJrSPOUg/UCVGbd9J7soo4QvXR6t1vzGwKQg=

OpenBSD 7.4 errata 019, August 19, 2024:

cron(8) and crontab(1) can crash due to incorrect /step values.
CVE-2024-43688

Apply by doing:
    signify -Vep /etc/signify/openbsd-74-base.pub -x 019_cron.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install cron and crontab:
    cd /usr/src/usr.sbin/cron
    make obj
    make
    make install
    cd /usr/src/usr.bin/crontab
    make obj
    make
    make install

Index: usr.sbin/cron/entry.c
===================================================================
RCS file: /cvs/src/usr.sbin/cron/entry.c,v
diff -u -p -r1.59 entry.c
--- usr.sbin/cron/entry.c	19 Jul 2023 21:26:02 -0000	1.59
+++ usr.sbin/cron/entry.c	15 Aug 2024 20:13:22 -0000
@@ -625,7 +625,10 @@ get_number(int *numptr, int low, const c
 		/* got a number, check for valid terminator */
 		if (!strchr(terms, ch))
 			goto bad;
-		*numptr = atoi(temp);
+		i = atoi(temp);
+		if (i < 0)
+			goto bad;
+		*numptr = i;
 		return (ch);
 	}
 
@@ -675,7 +678,7 @@ set_range(bitstr_t *bits, int low, int h
 	start -= low;
 	stop -= low;
 
-	if (step == 1) {
+	if (step <= 1 || step > stop) {
 		bit_nset(bits, start, stop);
 	} else {
 		for (i = start; i <= stop; i += step)
