untrusted comment: verify with openbsd-70-base.pub
RWR3KL+gSr4QZ69kIA/hbF1Wt7RWm5lEPC7L2kpcxqZ7lZYBfJm+LS5/6iluFgMecOXBFnTmQ8FGs3je1OItpFJLEfMtuupyDws=

OpenBSD 7.0 errata 005, November 26, 2021:

An unprivileged user could crash the kernel by using UNIX-domain
sockets in multiple threads.

Apply by doing:
    signify -Vep /etc/signify/openbsd-70-base.pub -x 005_unpcon.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/uipc_usrreq.c
===================================================================
RCS file: /cvs/src/sys/kern/uipc_usrreq.c,v
diff -u -p -r1.148.2.1 uipc_usrreq.c
--- sys/kern/uipc_usrreq.c	30 Oct 2021 18:11:56 -0000	1.148.2.1
+++ sys/kern/uipc_usrreq.c	17 Nov 2021 21:34:28 -0000
@@ -690,6 +690,13 @@ unlock:
 	solock(so);
 	unp->unp_flags &= ~UNP_CONNECTING;
 
+	/*
+	 * The peer socket could be closed by concurrent thread
+	 * when `so' and `vp' are unlocked.
+	 */
+	if (error == 0 && unp->unp_conn == NULL)
+		error = ECONNREFUSED;
+
 	return (error);
 }
 
