untrusted comment: verify with openbsd-69-base.pub
RWQQsAemppS46Pvg9KMdupU77OtuSEDKI2iE70OWlnmOE7fF8AqhHp+eoHDDfdqeV85PqIDZ2dr//VfIbrSQ2QfYtCsvReYy3gg=

OpenBSD 6.9 errata 019, October 31, 2021:

Opening /dev/bpf too quickly too often could lead to a kernel crash.

Apply by doing:
    signify -Vep /etc/signify/openbsd-69-base.pub -x 019_bpf.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/net/bpf.c
===================================================================
RCS file: /cvs/src/sys/net/bpf.c,v
retrieving revision 1.203
diff -u -p -r1.203 bpf.c
--- sys/net/bpf.c	21 Jan 2021 12:33:14 -0000	1.203
+++ sys/net/bpf.c	23 Oct 2021 16:00:36 -0000
@@ -1566,6 +1566,7 @@ bpf_allocbufs(struct bpf_d *d)
 	d->bd_sbuf = malloc(d->bd_bufsize, M_DEVBUF, M_NOWAIT);
 	if (d->bd_sbuf == NULL) {
 		free(d->bd_fbuf, M_DEVBUF, d->bd_bufsize);
+		d->bd_fbuf = NULL;
 		return (ENOMEM);
 	}
 
