untrusted comment: verify with openbsd-67-base.pub
RWRmkIA877Io3oGLnA7A2P08wRS3rsWG7PRB4MX3a+Y+DGR18PuJmyvkVqaaZuCJE/t7Cu6pkWabUU/scgmDWWdMEMzOcjwFgwI=

OpenBSD 6.7 errata 004, May 22, 2020:

A TLS client with peer verification disabled may crash when contacting a
server that sends an empty certificate list.

Apply by doing:
    signify -Vep /etc/signify/openbsd-67-base.pub -x 004_libssl.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libssl:
    cd /usr/src/lib/libssl
    make obj
    make clean
    make
    make install

Index: lib/libssl/tls13_client.c
===================================================================
RCS file: /cvs/src/lib/libssl/tls13_client.c,v
retrieving revision 1.54
diff -u -p -r1.54 tls13_client.c
--- lib/libssl/tls13_client.c	28 Apr 2020 20:37:22 -0000	1.54
+++ lib/libssl/tls13_client.c	18 May 2020 04:34:52 -0000
@@ -585,6 +585,14 @@ tls13_server_certificate_recv(struct tls
 			goto err;
 
 		cert = NULL;
+	}
+
+	/* A server must always provide a non-empty certificate list. */
+	if (sk_X509_num(certs) < 1) {
+		ctx->alert = SSL_AD_DECODE_ERROR;
+		tls13_set_errorx(ctx, TLS13_ERR_NO_PEER_CERTIFICATE, 0,
+		    "peer failed to provide a certificate", NULL);
+		goto err;
 	}
 
 	/*
Index: lib/libssl/tls13_internal.h
===================================================================
RCS file: /cvs/src/lib/libssl/tls13_internal.h,v
retrieving revision 1.67
diff -u -p -r1.67 tls13_internal.h
--- lib/libssl/tls13_internal.h	28 Apr 2020 20:37:22 -0000	1.67
+++ lib/libssl/tls13_internal.h	18 May 2020 04:34:52 -0000
@@ -43,6 +43,7 @@ __BEGIN_HIDDEN_DECLS
 #define TLS13_ERR_HRR_FAILED		17
 #define TLS13_ERR_TRAILING_DATA		18
 #define TLS13_ERR_NO_SHARED_CIPHER	19
+#define TLS13_ERR_NO_PEER_CERTIFICATE	21
 
 typedef void (*tls13_alert_cb)(uint8_t _alert_desc, void *_cb_arg);
 typedef ssize_t (*tls13_phh_recv_cb)(void *_cb_arg, CBS *_cbs);
Index: lib/libssl/tls13_legacy.c
===================================================================
RCS file: /cvs/src/lib/libssl/tls13_legacy.c,v
retrieving revision 1.3
diff -u -p -r1.3 tls13_legacy.c
--- lib/libssl/tls13_legacy.c	28 Apr 2020 20:37:22 -0000	1.3
+++ lib/libssl/tls13_legacy.c	18 May 2020 04:34:52 -0000
@@ -119,6 +119,9 @@ tls13_legacy_error(SSL *ssl)
 	case TLS13_ERR_NO_SHARED_CIPHER:
 		reason = SSL_R_NO_SHARED_CIPHER;
 		break;
+	case TLS13_ERR_NO_PEER_CERTIFICATE:
+		reason = SSL_R_PEER_DID_NOT_RETURN_A_CERTIFICATE;
+		break;
 	}
 
 	/* Something (probably libcrypto) already pushed an error on the stack. */
