untrusted comment: verify with openbsd-67-base.pub
RWRmkIA877Io3t0JrIwh/7nWH+W01V6FxIajdbLutjpsHA3GW2rnl8Kd9XxDypvknlOQblQq49KDv6oF9qXISed3J/ilNLsJyQA=

OpenBSD 6.7 errata 009, June 8, 2019:

libc's resolver could get into a corrupted state.

Apply by doing:
    signify -Vep /etc/signify/openbsd-67-base.pub -x 009_asr.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libc and static binaries:
    cd /usr/src/lib/libc
    make obj
    make
    make install
    cd /usr/src/bin
    make obj
    make
    make install
    cd /usr/src/sbin
    make obj
    make
    make install
    cd /usr/src/usr.bin/bgplg
    make obj
    make
    make install

Index: lib/libc/asr/asr.c
===================================================================
RCS file: /cvs/src/lib/libc/asr/asr.c,v
diff -u -p -u -r1.62 asr.c
--- lib/libc/asr/asr.c	24 Oct 2019 05:57:41 -0000	1.62
+++ lib/libc/asr/asr.c	4 Jun 2020 14:37:37 -0000
@@ -171,6 +171,8 @@ asr_run(struct asr_query *as, struct asr
 {
 	int	r, saved_errno = errno;
 
+	memset(ar, 0, sizeof(*ar));
+
 	DPRINT("asr: asr_run(%p, %p) %s ctx=[%p]\n", as, ar,
 	    _asr_querystr(as->as_type), as->as_ctx);
 	r = as->as_run(as, ar);
