untrusted comment: verify with openbsd-67-base.pub
RWRmkIA877Io3pfvSyqPL3qzhu3VbhXwHbF09fre4lNBIQAj3y5cTiXYufB69zqHIxVkA4+kkbC/fYs+zUwWxB54kfFHXHXUCAk=

OpenBSD 6.7 errata 006, May 25, 2020:

Incorrect use of getpeername(2) storage for outgoing IPv6 connections
corrupts stack memory.  The nature of the corruption and existing
mitigations appear to make this difficult to effectively target.

Apply by doing:
    signify -Vep /etc/signify/openbsd-67-base.pub -x 006_smtpd_sockaddr.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install smtpd:
    cd /usr/src/usr.sbin/smtpd
    make obj
    make
    make install

Index: usr.sbin/smtpd/mta_session.c
===================================================================
RCS file: /cvs/src/usr.sbin/smtpd/mta_session.c,v
retrieving revision 1.135
diff -u -p -r1.135 mta_session.c
--- usr.sbin/smtpd/mta_session.c	24 Apr 2020 11:34:07 -0000	1.135
+++ usr.sbin/smtpd/mta_session.c	21 May 2020 14:40:49 -0000
@@ -1809,21 +1809,25 @@ mta_filter_end(struct mta_session *s)
 static void
 mta_connected(struct mta_session *s)
 {
-	struct sockaddr sa_src;
-	struct sockaddr sa_dest;
+	struct sockaddr_storage sa_src;
+	struct sockaddr_storage sa_dest;
 	int sa_len;
 
 	log_info("%016"PRIx64" mta connected", s->id);
 
-	if (getsockname(io_fileno(s->io), &sa_src, &sa_len) == -1)
+	sa_len = sizeof sa_src;
+	if (getsockname(io_fileno(s->io),
+	    (struct sockaddr *)&sa_src, &sa_len) == -1)
 		bzero(&sa_src, sizeof sa_src);
-	if (getpeername(io_fileno(s->io), &sa_dest, &sa_len) == -1)
+	sa_len = sizeof sa_dest;
+	if (getpeername(io_fileno(s->io),
+	    (struct sockaddr *)&sa_dest, &sa_len) == -1)
 		bzero(&sa_dest, sizeof sa_dest);
 
 	mta_report_link_connect(s,
 	    s->route->dst->ptrname, 1,
-	    (struct sockaddr_storage *)&sa_src,
-	    (struct sockaddr_storage *)&sa_dest);
+	    &sa_src,
+	    &sa_dest);
 }
 
 static void
