untrusted comment: verify with openbsd-66-base.pub
RWSvK/c+cFe24PukmZrJXpIqL+Vgoao8Aq15zOrF/7X/MxLGuZupFPUHNvyeiEO7jisX64FviwLI25nNHKFoLu+qda8f3lE7zgs=

OpenBSD 6.6 errata 024, April 7, 2020:

dhcpd could reference freed memory after releasing a lease with
an unusually long uid.

Apply by doing:
    signify -Vep /etc/signify/openbsd-66-base.pub -x 024_dhcpd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install dhcpd:
    cd /usr/src/usr.sbin/dhcpd
    make clean
    make
    make install

Index: usr.sbin/dhcpd/memory.c
===================================================================
RCS file: /cvs/src/usr.sbin/dhcpd/memory.c,v
diff -u -p -r1.28 memory.c
--- usr.sbin/dhcpd/memory.c	13 Feb 2017 23:04:05 -0000	1.28
+++ usr.sbin/dhcpd/memory.c	5 Apr 2020 17:15:44 -0000
@@ -502,7 +502,8 @@ supersede_lease(struct lease *comp, stru
 			uid_hash_delete(comp);
 			enter_uid = 1;
 			if (comp->uid != &comp->uid_buf[0]) {
-				free(comp->uid);
+				if (comp->uid != lease->uid)
+					free(comp->uid);
 				comp->uid_max = 0;
 				comp->uid_len = 0;
 			}
