untrusted comment: verify with openbsd-65-base.pub
RWSZaRmt1LEQTyAmZoGi+KTQrTRvG7QJmcdl5tk/19+RULGexz7kfJP/BP+jdxuKg2OuTvZwFXZppEiUSCqQuMhUSgUvsCMpLQk=

OpenBSD 6.5 errata 032, March 10, 2020:   

Missing input validation in sysctl(2) can be used to crash the kernel.

Apply by doing:
    signify -Vep /etc/signify/openbsd-65-base.pub -x 032_sysctl.patch.sig \      
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/kern_sysctl.c
===================================================================
RCS file: /var/cvs/src/sys/kern/kern_sysctl.c,v
retrieving revision 1.354
diff -u -p -r1.354 kern_sysctl.c
--- sys/kern/kern_sysctl.c	29 Jan 2019 14:07:15 -0000	1.354
+++ sys/kern/kern_sysctl.c	10 Mar 2020 03:39:49 -0000
@@ -1462,7 +1462,7 @@ sysctl_doproc(int *name, u_int namelen, 
 	buflen = where != NULL ? *sizep : 0;
 	needed = error = 0;
 
-	if (namelen != 4 || name[2] < 0 || name[3] < 0 ||
+	if (namelen != 4 || name[2] <= 0 || name[3] < 0 ||
 	    name[2] > sizeof(*kproc))
 		return (EINVAL);
 	op = name[0];
