/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow;

import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.record.AbstractRecord;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.action.ReceivingAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendingAction;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorkflowTraceUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    public static ProtocolMessage getFirstReceivedMessage(ProtocolMessageType type, WorkflowTrace trace) {
        List<ProtocolMessage> messageList = WorkflowTraceUtil.getAllReceivedMessages(trace);
        if ((messageList = WorkflowTraceUtil.filterMessageList(messageList, type)).isEmpty()) {
            return null;
        }
        return messageList.get(0);
    }

    public static HandshakeMessage getFirstReceivedMessage(HandshakeMessageType type, WorkflowTrace trace) {
        List<ProtocolMessage> messageList = WorkflowTraceUtil.getAllReceivedMessages(trace);
        List<HandshakeMessage> handshakeMessageList = WorkflowTraceUtil.filterHandshakeMessagesFromList(messageList);
        if ((handshakeMessageList = WorkflowTraceUtil.filterMessageList(handshakeMessageList, type)).isEmpty()) {
            return null;
        }
        return handshakeMessageList.get(0);
    }

    public static HandshakeMessage getLastReceivedMessage(HandshakeMessageType type, WorkflowTrace trace) {
        List<ProtocolMessage> messageList = WorkflowTraceUtil.getAllReceivedMessages(trace);
        List<HandshakeMessage> handshakeMessageList = WorkflowTraceUtil.filterHandshakeMessagesFromList(messageList);
        if ((handshakeMessageList = WorkflowTraceUtil.filterMessageList(handshakeMessageList, type)).isEmpty()) {
            return null;
        }
        return handshakeMessageList.get(handshakeMessageList.size() - 1);
    }

    public static ProtocolMessage getLastReceivedMessage(ProtocolMessageType type, WorkflowTrace trace) {
        List<ProtocolMessage> messageList = WorkflowTraceUtil.getAllReceivedMessages(trace);
        if ((messageList = WorkflowTraceUtil.filterMessageList(messageList, type)).isEmpty()) {
            return null;
        }
        return messageList.get(messageList.size() - 1);
    }

    public static AbstractRecord getLastReceivedRecord(WorkflowTrace trace) {
        List<AbstractRecord> recordList = WorkflowTraceUtil.getAllReceivedRecords(trace);
        if (recordList.isEmpty()) {
            return null;
        }
        return recordList.get(recordList.size() - 1);
    }

    public static ProtocolMessage getFirstSendMessage(ProtocolMessageType type, WorkflowTrace trace) {
        List<ProtocolMessage> messageList = WorkflowTraceUtil.getAllSendMessages(trace);
        if ((messageList = WorkflowTraceUtil.filterMessageList(messageList, type)).isEmpty()) {
            return null;
        }
        return messageList.get(0);
    }

    public static ExtensionMessage getFirstSendExtension(ExtensionType type, WorkflowTrace trace) {
        List<ExtensionMessage> extensionList = WorkflowTraceUtil.getAllSendExtensions(trace);
        if ((extensionList = WorkflowTraceUtil.filterExtensionList(extensionList, type)).isEmpty()) {
            return null;
        }
        return extensionList.get(0);
    }

    public static List<HandshakeMessage> getAllSendHandshakeMessages(WorkflowTrace trace) {
        return WorkflowTraceUtil.filterHandshakeMessagesFromList(WorkflowTraceUtil.getAllSendMessages(trace));
    }

    public static List<HandshakeMessage> getAllReceivedHandshakeMessages(WorkflowTrace trace) {
        return WorkflowTraceUtil.filterHandshakeMessagesFromList(WorkflowTraceUtil.getAllReceivedMessages(trace));
    }

    public static List<ExtensionMessage> getAllSendExtensions(WorkflowTrace trace) {
        List<HandshakeMessage> handshakeMessageList = WorkflowTraceUtil.getAllSendHandshakeMessages(trace);
        LinkedList<ExtensionMessage> extensionList = new LinkedList<ExtensionMessage>();
        for (HandshakeMessage message : handshakeMessageList) {
            extensionList.addAll(message.getExtensions());
        }
        return extensionList;
    }

    public static List<ExtensionMessage> getAllReceivedExtensions(WorkflowTrace trace) {
        List<HandshakeMessage> handshakeMessageList = WorkflowTraceUtil.getAllReceivedHandshakeMessages(trace);
        LinkedList<ExtensionMessage> extensionList = new LinkedList<ExtensionMessage>();
        for (HandshakeMessage message : handshakeMessageList) {
            extensionList.addAll(message.getExtensions());
        }
        return extensionList;
    }

    public static HandshakeMessage getFirstSendMessage(HandshakeMessageType type, WorkflowTrace trace) {
        List<ProtocolMessage> messageList = WorkflowTraceUtil.getAllSendMessages(trace);
        List<HandshakeMessage> handshakeMessageList = WorkflowTraceUtil.filterHandshakeMessagesFromList(messageList);
        if ((handshakeMessageList = WorkflowTraceUtil.filterMessageList(handshakeMessageList, type)).isEmpty()) {
            return null;
        }
        return handshakeMessageList.get(0);
    }

    public static HandshakeMessage getLastSendMessage(HandshakeMessageType type, WorkflowTrace trace) {
        List<ProtocolMessage> messageList = WorkflowTraceUtil.getAllSendMessages(trace);
        List<HandshakeMessage> handshakeMessageList = WorkflowTraceUtil.filterHandshakeMessagesFromList(messageList);
        if ((handshakeMessageList = WorkflowTraceUtil.filterMessageList(handshakeMessageList, type)).isEmpty()) {
            return null;
        }
        return handshakeMessageList.get(handshakeMessageList.size() - 1);
    }

    public static ProtocolMessage getLastSendMessage(ProtocolMessageType type, WorkflowTrace trace) {
        List<ProtocolMessage> messageList = WorkflowTraceUtil.getAllSendMessages(trace);
        if ((messageList = WorkflowTraceUtil.filterMessageList(messageList, type)).isEmpty()) {
            return null;
        }
        return messageList.get(messageList.size() - 1);
    }

    public static boolean didReceiveMessage(ProtocolMessageType type, WorkflowTrace trace) {
        return WorkflowTraceUtil.getFirstReceivedMessage(type, trace) != null;
    }

    public static boolean didReceiveMessage(HandshakeMessageType type, WorkflowTrace trace) {
        return WorkflowTraceUtil.getFirstReceivedMessage(type, trace) != null;
    }

    public static boolean didSendMessage(ProtocolMessageType type, WorkflowTrace trace) {
        return WorkflowTraceUtil.getFirstSendMessage(type, trace) != null;
    }

    public static boolean didSendMessage(HandshakeMessageType type, WorkflowTrace trace) {
        return WorkflowTraceUtil.getFirstSendMessage(type, trace) != null;
    }

    public static ProtocolMessage getLastReceivedMessage(WorkflowTrace trace) {
        List<ProtocolMessage> messageList = WorkflowTraceUtil.getAllReceivedMessages(trace);
        if (messageList.isEmpty()) {
            return null;
        }
        return messageList.get(messageList.size() - 1);
    }

    private static List<ProtocolMessage> filterMessageList(List<ProtocolMessage> messages, ProtocolMessageType type) {
        LinkedList<ProtocolMessage> returnedMessages = new LinkedList<ProtocolMessage>();
        for (ProtocolMessage protocolMessage : messages) {
            if (protocolMessage.getProtocolMessageType() != type) continue;
            returnedMessages.add(protocolMessage);
        }
        return returnedMessages;
    }

    private static List<ExtensionMessage> filterExtensionList(List<ExtensionMessage> extensions, ExtensionType type) {
        LinkedList<ExtensionMessage> resultList = new LinkedList<ExtensionMessage>();
        for (ExtensionMessage extension : extensions) {
            if (extension.getExtensionTypeConstant() != type) continue;
            resultList.add(extension);
        }
        return resultList;
    }

    public static List<HandshakeMessage> filterHandshakeMessagesFromList(List<ProtocolMessage> messages) {
        LinkedList<HandshakeMessage> returnedMessages = new LinkedList<HandshakeMessage>();
        for (ProtocolMessage protocolMessage : messages) {
            if (!protocolMessage.isHandshakeMessage()) continue;
            returnedMessages.add((HandshakeMessage)protocolMessage);
        }
        return returnedMessages;
    }

    private static List<HandshakeMessage> filterMessageList(List<HandshakeMessage> messages, HandshakeMessageType type) {
        LinkedList<HandshakeMessage> returnedMessages = new LinkedList<HandshakeMessage>();
        for (HandshakeMessage handshakeMessage : messages) {
            if (handshakeMessage.getHandshakeMessageType() != type) continue;
            returnedMessages.add(handshakeMessage);
        }
        return returnedMessages;
    }

    public static List<ProtocolMessage> getAllReceivedMessages(WorkflowTrace trace) {
        LinkedList<ProtocolMessage> receivedMessage = new LinkedList<ProtocolMessage>();
        for (ReceivingAction action : trace.getReceivingActions()) {
            if (action.getReceivedMessages() == null) continue;
            receivedMessage.addAll(action.getReceivedMessages());
        }
        return receivedMessage;
    }

    public static List<ProtocolMessage> getAllReceivedMessages(WorkflowTrace trace, ProtocolMessageType type) {
        LinkedList<ProtocolMessage> receivedMessage = new LinkedList<ProtocolMessage>();
        for (ProtocolMessage message : WorkflowTraceUtil.getAllReceivedMessages(trace)) {
            if (message.getProtocolMessageType() != type) continue;
            receivedMessage.add(message);
        }
        return receivedMessage;
    }

    public static List<ProtocolMessage> getAllSendMessages(WorkflowTrace trace) {
        LinkedList<ProtocolMessage> sendMessages = new LinkedList<ProtocolMessage>();
        for (SendingAction action : trace.getSendingActions()) {
            sendMessages.addAll(action.getSendMessages());
        }
        return sendMessages;
    }

    public static Boolean didReceiveTypeBeforeType(ProtocolMessageType protocolMessageType, HandshakeMessageType type, WorkflowTrace trace) {
        List<ProtocolMessage> receivedMessages = WorkflowTraceUtil.getAllReceivedMessages(trace);
        for (ProtocolMessage message : receivedMessages) {
            if (message.getProtocolMessageType() == protocolMessageType) {
                return true;
            }
            if (!(message instanceof HandshakeMessage) || ((HandshakeMessage)message).getHandshakeMessageType() != type) continue;
            return false;
        }
        return false;
    }

    public static List<AbstractRecord> getAllReceivedRecords(WorkflowTrace trace) {
        LinkedList<AbstractRecord> receivedRecords = new LinkedList<AbstractRecord>();
        for (ReceivingAction action : trace.getReceivingActions()) {
            receivedRecords.addAll(action.getReceivedRecords());
        }
        return receivedRecords;
    }

    public static List<AbstractRecord> getAllSendRecords(WorkflowTrace trace) {
        LinkedList<AbstractRecord> sendRecords = new LinkedList<AbstractRecord>();
        for (SendingAction action : trace.getSendingActions()) {
            if (action.getSendRecords() == null) continue;
            sendRecords.addAll(action.getSendRecords());
        }
        return sendRecords;
    }

    public static SendingAction getLastSendingAction(WorkflowTrace trace) {
        List<SendingAction> sendingActions = trace.getSendingActions();
        return sendingActions.get(sendingActions.size() - 1);
    }

    private WorkflowTraceUtil() {
    }
}

