/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.text;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.text.TextStyleKeys;
import org.jfree.layouting.input.style.values.CSSStringType;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValueList;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;

public class TextOverflowEllipsisResolveHandler
implements ResolveHandler {
    @Override
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[0];
    }

    @Override
    public void resolve(LayoutProcess layoutProcess, LayoutElement layoutElement, StyleKey styleKey) {
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        CSSValue cSSValue = layoutContext.getValue(styleKey);
        CSSStringValue cSSStringValue = null;
        CSSStringValue cSSStringValue2 = null;
        if (cSSValue instanceof CSSValueList) {
            CSSValueList cSSValueList = (CSSValueList)cSSValue;
            if (cSSValueList.getLength() == 2) {
                cSSStringValue = this.filterString(cSSValueList.getItem(0));
                cSSStringValue2 = this.filterString(cSSValueList.getItem(1));
            } else if (cSSValueList.getLength() == 1) {
                cSSStringValue = this.filterString(cSSValueList.getItem(0));
                cSSStringValue2 = this.filterString(cSSValueList.getItem(0));
            }
        }
        if (cSSStringValue == null) {
            cSSStringValue = new CSSStringValue(CSSStringType.STRING, "..");
        }
        if (cSSStringValue2 == null) {
            cSSStringValue2 = new CSSStringValue(CSSStringType.STRING, "..");
        }
        layoutContext.setValue(TextStyleKeys.X_BLOCK_TEXT_OVERFLOW_ELLIPSIS, cSSStringValue2);
        layoutContext.setValue(TextStyleKeys.X_LINE_TEXT_OVERFLOW_ELLIPSIS, cSSStringValue);
    }

    private CSSStringValue filterString(CSSValue cSSValue) {
        if (!(cSSValue instanceof CSSStringValue)) {
            return null;
        }
        return (CSSStringValue)cSSValue;
    }
}

