/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.preferences.ListProperty;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Pair;

public class OverlappingWays
extends Test {
    private MultiMap<Pair<Node, Node>, WaySegment> nodePairs;
    protected static final int OVERLAPPING_HIGHWAY = 101;
    protected static final int OVERLAPPING_RAILWAY = 102;
    protected static final int OVERLAPPING_WAY = 103;
    protected static final int OVERLAPPING_HIGHWAY_AREA = 111;
    protected static final int OVERLAPPING_RAILWAY_AREA = 112;
    protected static final int OVERLAPPING_WAY_AREA = 113;
    protected static final int DUPLICATE_WAY_SEGMENT = 121;
    protected static final ListProperty IGNORED_KEYS = new ListProperty("overlapping-ways.ignored-keys", Arrays.asList("barrier", "building", "building:part", "historic:building", "demolished:building", "removed:building", "disused:building", "abandoned:building", "proposed:building", "man_made"));

    public OverlappingWays() {
        super(I18n.tr("Overlapping ways", new Object[0]), I18n.tr("This test checks that a connection between two nodes is not used by more than one way.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.nodePairs = new MultiMap(1000);
    }

    private static boolean parentMultipolygonConcernsArea(OsmPrimitive p) {
        return p.referrers(Relation.class).anyMatch(Relation::concernsArea);
    }

    @Override
    public void endTest() {
        HashMap seenWays = new HashMap(500);
        ArrayList<TestError> preliminaryErrors = new ArrayList<TestError>();
        for (Set<WaySegment> duplicated : this.nodePairs.values()) {
            int ways = duplicated.size();
            if (ways <= 1) continue;
            ArrayList<Way> prims = new ArrayList<Way>();
            ArrayList<Way> currentWays = new ArrayList<Way>();
            int highway = 0;
            int railway = 0;
            int area = 0;
            for (WaySegment ws : duplicated) {
                if (ws.way.hasKey("highway")) {
                    ++highway;
                } else if (ws.way.hasKey("railway")) {
                    ++railway;
                }
                Boolean ar = OsmUtils.getOsmBoolean(ws.way.get("area"));
                if (ar != null && ar.booleanValue()) {
                    ++area;
                }
                if (ws.way.concernsArea() || OverlappingWays.parentMultipolygonConcernsArea(ws.way)) {
                    ++area;
                    --ways;
                }
                prims.add(ws.way);
                currentWays.add(ws.way);
            }
            Collection highlight = (Collection)seenWays.get(currentWays);
            if (highlight == null) {
                int type;
                String errortype;
                if (area > 0) {
                    if (ways == 0 || duplicated.size() == area) continue;
                    if (highway == ways) {
                        errortype = I18n.tr("Highways share segment with area", new Object[0]);
                        type = 111;
                    } else if (railway == ways) {
                        errortype = I18n.tr("Railways share segment with area", new Object[0]);
                        type = 112;
                    } else {
                        errortype = I18n.tr("Ways share segment with area", new Object[0]);
                        type = 113;
                    }
                } else if (highway == ways) {
                    errortype = I18n.tr("Overlapping highways", new Object[0]);
                    type = 101;
                } else if (railway == ways) {
                    errortype = I18n.tr("Overlapping railways", new Object[0]);
                    type = 102;
                } else {
                    errortype = I18n.tr("Overlapping ways", new Object[0]);
                    type = 103;
                }
                Severity severity = type < 111 ? Severity.WARNING : Severity.OTHER;
                preliminaryErrors.add(TestError.builder(this, severity, type).message(errortype).primitives(prims).highlightWaySegments(duplicated).build());
                seenWays.put(currentWays, duplicated);
                continue;
            }
            highlight.addAll(duplicated);
        }
        for (TestError error : preliminaryErrors) {
            if (error.getSeverity() != Severity.WARNING && error.getHighlighted().size() / error.getPrimitives().size() < 3) continue;
            boolean ignore = false;
            Iterator iterator = IGNORED_KEYS.get().iterator();
            while (iterator.hasNext()) {
                String ignoredKey = (String)iterator.next();
                if (!error.getPrimitives().stream().anyMatch(p -> p.hasKey(ignoredKey))) continue;
                ignore = true;
                break;
            }
            if (ignore) continue;
            this.errors.add(error);
        }
        super.endTest();
        this.nodePairs = null;
    }

    protected static Set<WaySegment> checkDuplicateWaySegment(Way w) {
        TreeSet<WaySegment> segments = new TreeSet<WaySegment>((o1, o2) -> {
            List<Node> n1 = Arrays.asList(o1.getFirstNode(), o1.getSecondNode());
            List<Node> n2 = Arrays.asList(o2.getFirstNode(), o2.getSecondNode());
            Collections.sort(n1);
            Collections.sort(n2);
            int first = n1.get(0).compareTo((IPrimitive)n2.get(0));
            int second = n1.get(1).compareTo((IPrimitive)n2.get(1));
            return first != 0 ? first : second;
        });
        HashSet<WaySegment> duplicateWaySegments = new HashSet<WaySegment>();
        for (int i = 0; i < w.getNodesCount() - 1; ++i) {
            boolean wasInSet;
            WaySegment segment = new WaySegment(w, i);
            boolean bl = wasInSet = !segments.add(segment);
            if (!wasInSet) continue;
            duplicateWaySegments.add(segment);
        }
        return duplicateWaySegments;
    }

    @Override
    public void visit(Way w) {
        Set<WaySegment> duplicateWaySegment = OverlappingWays.checkDuplicateWaySegment(w);
        if (!duplicateWaySegment.isEmpty()) {
            this.errors.add(TestError.builder(this, Severity.ERROR, 121).message(I18n.tr("Way contains segment twice", new Object[0])).primitives(w).highlightWaySegments(duplicateWaySegment).build());
            return;
        }
        Node lastN = null;
        int i = -2;
        for (Node n : w.getNodes()) {
            ++i;
            if (lastN == null) {
                lastN = n;
                continue;
            }
            this.nodePairs.put(Pair.sort(new Pair<Node, Node>(lastN, n)), new WaySegment(w, i));
            lastN = n;
        }
    }
}

