package Google::Ads::AdWords::v201302::BudgetOptimizer;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201302' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201302::BiddingStrategy);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %BiddingStrategy__Type_of :ATTR(:get<BiddingStrategy__Type>);
my %enhancedCpcEnabled_of :ATTR(:get<enhancedCpcEnabled>);
my %bidCeiling_of :ATTR(:get<bidCeiling>);

__PACKAGE__->_factory(
    [ qw(        BiddingStrategy__Type
        enhancedCpcEnabled
        bidCeiling

    ) ],
    {
        'BiddingStrategy__Type' => \%BiddingStrategy__Type_of,
        'enhancedCpcEnabled' => \%enhancedCpcEnabled_of,
        'bidCeiling' => \%bidCeiling_of,
    },
    {
        'BiddingStrategy__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'enhancedCpcEnabled' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'bidCeiling' => 'Google::Ads::AdWords::v201302::Money',
    },
    {

        'BiddingStrategy__Type' => 'BiddingStrategy.Type',
        'enhancedCpcEnabled' => 'enhancedCpcEnabled',
        'bidCeiling' => 'bidCeiling',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201302::BudgetOptimizer

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
BudgetOptimizer from the namespace https://adwords.google.com/api/adwords/cm/v201302.

In budget optimizer, Google automatically places bids for the user based on their daily/monthly budget. <span class="constraint AdxEnabled">This is disabled for AdX.</span> 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * enhancedCpcEnabled


=item * bidCeiling




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

