package Google::Ads::AdWords::v201302::AssociatedCampaign;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201302' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %associatedCampaignName_of :ATTR(:get<associatedCampaignName>);
my %associatedCampaignId_of :ATTR(:get<associatedCampaignId>);
my %associatedCampaignStatus_of :ATTR(:get<associatedCampaignStatus>);
my %budgetCampaignAssociationStatus_of :ATTR(:get<budgetCampaignAssociationStatus>);

__PACKAGE__->_factory(
    [ qw(        associatedCampaignName
        associatedCampaignId
        associatedCampaignStatus
        budgetCampaignAssociationStatus

    ) ],
    {
        'associatedCampaignName' => \%associatedCampaignName_of,
        'associatedCampaignId' => \%associatedCampaignId_of,
        'associatedCampaignStatus' => \%associatedCampaignStatus_of,
        'budgetCampaignAssociationStatus' => \%budgetCampaignAssociationStatus_of,
    },
    {
        'associatedCampaignName' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'associatedCampaignId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'associatedCampaignStatus' => 'Google::Ads::AdWords::v201302::AssociatedCampaign::CampaignStatus',
        'budgetCampaignAssociationStatus' => 'Google::Ads::AdWords::v201302::AssociatedCampaign::BudgetCampaignAssociationStatus',
    },
    {

        'associatedCampaignName' => 'associatedCampaignName',
        'associatedCampaignId' => 'associatedCampaignId',
        'associatedCampaignStatus' => 'associatedCampaignStatus',
        'budgetCampaignAssociationStatus' => 'budgetCampaignAssociationStatus',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201302::AssociatedCampaign

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
AssociatedCampaign from the namespace https://adwords.google.com/api/adwords/cm/v201302.

This class represents a campaign which is or was linked to the parent budget object. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * associatedCampaignName


=item * associatedCampaignId


=item * associatedCampaignStatus


=item * budgetCampaignAssociationStatus




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

